BEM.DOM.decl({
    block: 'paranja',
    modName: 'autoclosable',
    modVal: 'yes'
}, {

    onSetMod: {
        state: {
            open: function() {
                var preventOn = this.params.autoclosable.preventOn;
                if(preventOn && preventOn.length) {
                    // Установка в следующем такте нужна для того, чтобы предотвратить
                    // автозакрытие при открытии paranja. https://st.yandex-team.ru/ISLPAGE-234
                    this.afterCurrentEvent(function() {
                        this.bindToDoc('leftclick tap', this._onClick, this);
                    });
                }
                this.__base.apply(this, arguments);
            },

            close: function() {
                this.unbindFromDoc('leftclick tap', this._onClick, this);
                this.__base.apply(this, arguments);
            }
        }
    },

    getDefaultParams: function() {
        return $.extend(this.__base(), {
            autoclosable: {}
        });
    },

    /**
     * Обработчик клика, навешанный на document
     * @private
     * @param {Event} e
     */
    _onClick: function(e) {
        var preventOn = this.params.autoclosable.preventOn,
            target = $(e.target),
            preventLen = preventOn.length,
            blocksLen,
            blocks, i, j,
            contains = false;

        // Метка, чтобы выйти из внутреннего цикла
        lookup:
        for(i = 0; i < preventLen; i++) {
            blocks = this.findBlocksInside(this.domElem.parent(), preventOn[i]);
            blocksLen = blocks.length;

            for(j = 0; j < blocksLen; j++) {
                if(preventOn[i].modName &&
                   !blocks[j].hasMod(preventOn[i].modName, preventOn[i].modVal)) {
                    continue;
                }

                contains = blocks[j].containsDomElem(target) || blocks[j][0] === e.target;

                if(contains) {
                    break lookup; // Выход из внешнего цикла
                }
            }
        }

        if(!contains) {
            this.close();
        }
    }
});
