describe('paranja_autoclosable_yes', function() {
    var paranja,
        example,
        bemjson = {
            block: 'example',
            content: [
                {
                    block: 'preventer',
                    mods: {prevent: 'yes'},
                    content: 'I`am going prevent close'
                },
                {
                    block: 'paranja',
                    mods: {autoclosable: 'yes'},
                    js: {
                        autoclosable: {
                            preventOn: [
                                {block: 'preventer', modName: 'prevent', modVal: 'yes'}
                            ]
                        }
                    }
                }
            ]
        };

    beforeEach(function(done) {
        example = build(bemjson);
        paranja = example.findBlockInside('paranja');
        paranja.open();
        BEM.DOM.afterCurrentEvent(done);

    });

    describe('#API', function() {
        it('должен закрывать паранджу по клику на ней', function() {
            paranja.domElem.trigger('click');
            expect(paranja.hasMod('state', 'close')).toBe(true);
        });
        it('клик по блоку, заданному параметром preventOn, не должен закрывать паранджу', function() {
            var preventer = example.findBlockInside('preventer');
            preventer.domElem.trigger('click');
            expect(paranja.hasMod('state', 'open')).toBe(true);
        });
    });

    afterEach(function() {
        BEM.DOM.destruct(example.domElem);
    });

    function build(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem(bemjson.block);
    }

});
