## Описание
Блок `paranja` («паранджа») накладывает на страницу паранджу – полупрозрачный элемент, который затемняет и перекрывает часть содержимого страницы, кроме управляющего блока, для которого она вызывается. Блок умеет открываться и закрываться. 

---
**NB** На winPhone 7.5 в IE9 не работает CSS-свойство `position: fixed`. Блок будет работать некорректно.

---

###Объявление блока на странице

Подключение паранджи для вызывающего элемента, например, кнопки. BEMJSON: 

```js
{
    block: 'b-page'
    ...
    content: [
        { // управляющий блок – вызывает паранджу
            block: 'button',
            mods: {size: 'm'},
            content: 'Показать паранджу'
        },
        {
            block:  'paranja', // имя блока
            js: { //JS-параметры для связи паранджи и вызывающего ее блока
                rel: [
                    {elem: '.button', event: 'click', method: 'open'},
                    {elem: '.paranja', event: 'click', method: 'close'}
                ]
            }
        },
        ...
    ]
 ...
}
```

<!-- %%paranja.examples/10-abstract/10-abstract%% -->
 
Открытие паранджи инициируется по некоторым событиям на **управляющем элементе**. Закрытие – при клике на парандже.  
БЭМ-события возникающее на экземпляре блока `paranja`:

* `close` – при закрытии паранджи;
* `open` – при открытии паранджи;
* `click` – при `leftclick` или `tap` по парандже.

**Управляющим элементом** может быть любой элемент – DOM-узел (или несколько), который про блок `paranja` может не знать. Параметры управляющему элементу передаются через JS-параметр `rel`.

```js
rel: [
    {elem: '.button', event: 'click', method: 'open'},
    {elem: '.paranja', event: 'click', method: 'close'}
]
```
Здесь указано, что при наступлении события `click` на DOM-узлах, которые соответствуют селектору `.button` (управляющему элементу), необходимо вызвать метод `open` блока `paranja`. А при наступлении события `click` на паранже (DOM-узел с селектором `.paranja`) вызвать метод блока `close`.

Параметры:

* `elem` –  селектор управляющего элемента, если явно не указан будет использован DOM-узел блока `paranja`; 
* `event` – событие возникающее на управляющем элементе (или парандже), обязательный параметр;
* `method` – вызываемый метод блока `paranja` – `open` или `close`, при наступлении заданного события в `event`.


###Модификаторы блока

#### Состояния паранджи
Парандже, при вызове одного из методов блока `open` или `close`, назначается модификатор состояния `state` со значением `open` (паранджа открыта) или `close` (паранджа закрыта) соответственно. Значение модификатору `state` во входных данных явно не устанавливается. По умолчанию при инициализации блока выставляется  состояние `_state_close`.

#### Автоматическое закрытие при клике за пределами паранджи

Для автоматического закрытия паранджи при клике по ней или за ее пределами по любому элементу нужно добавить в зависимости модификатор `autoclosable` со значением `yes` и выставить во входных данных блоку `paranja` такой же модификатор: `mods: {autoclosable: 'yes'}`.

Есть возможность не закрывать паранджу, если `leftclick` (или `tap`) произошел на блоках, которые указаны в JS-параметре `autoclosable.peventOn`. Задаются такие блоки следующим образом (см. на JS-параметры блока `paranja` в примере):

```js
 preventOn: [
     {block: 'имя_блокa', modName: 'модификатор_блока', modVal: 'значение_модификатора'}     
 ]    
```

Модификатор и его значение могут быть произвольные, но должны обязательно совпадать с указанными значениями во входных данных блока. (см. пример для блока `button` c `mods: {'on-top': 'yes'}`).

Элементы, клики по которым не закрывают паранджу будут искаться внутри родительского DOM-узла паранджи и должны располагаться на более высоком слое (`z-index`), чем паранджа. 


```js
...
{ // блок вызывающий паранжу
    block: 'button',
    mods: {size: 'm'},
    content: 'Показать паранджу'
},
{ // блок по клику на который, паранджа не закроется
    block: 'button',
    mods: {size: 'm', 'on-top': 'yes'}, // 'on-top' для указания z-indeх и параметра autoclosable.preventOn
    content: 'Клик по этой кнопке не приведет к закрытию паранджи, чего не скажешь про клик по шапке'
},
{
    block:  'paranja',
    mods: {autoclosable: 'yes'}, // модификатор для автоматического закрытия паранджи
    js: { // JS-параметры паранджи
        rel: [
            {elem: '.button', event: 'focus', method: 'open'},
            {elem: '.paranja', event: 'click', method: 'close'}
        ],
        autoclosable: { 
        // JS-параметр с набором блоков, клик по которым не вызовет закрытие паранджи
            preventOn: [
                {block: 'button', modName: 'on-top', modVal: 'yes'} // блок не вызывающий закрытие паранджи
            ]
        }
    }
},
...        
```

<!-- %%paranja.examples/15-autoclosable/15-autoclosable%% -->

#### Тема оформления паранджи
``` mods: {themе: 'normal'} ```

Модификатор `theme` со значением `normal` – паранджа черного цвета с прозрачностью 0.15. 
Добавляется по умолчанию в BEMHTML-шаблоне блока при его инициализации.

