describe('paranja', function() {
    'use strict';

    var paranja,
        example,
        bemjson = {
            block: 'example',
            content: [
                {
                    block: 'paranja',
                    js: {
                        rel: [
                            {elem: '.example', event: 'click', method: 'open'}
                        ]
                    }
                }
            ]
        };

    beforeEach(function() {
        example = build(bemjson);
        paranja = example.findBlockInside('paranja');
    });

    describe('#initial', function() {
        it('вызывает метод, переданный в rel.method, по событию rel.event на элементе rel.element ', function() {
            example.domElem.trigger('click');
            expect(paranja.hasMod('state', 'open')).toBe(true);
        });
    });

    describe('#API', function() {
        describe('open()', function() {
            it('открывает паранджу', function(){
                paranja.open();
                expect(paranja.hasMod('state', 'open')).toBe(true);
            });
        });

        describe('close()', function() {
            it('закрывает паранджу', function(){
                paranja.open();
                paranja.close();
                expect(paranja.hasMod('state', 'close')).toBe(true);
            });
        });
    });

    describe('#events', function() {
        it('leftclick/tap по парандже генеригует событие "click"', function() {
            var spy = jasmine.createSpy('spy');
            paranja.on('click', spy);

            paranja.open();
            paranja.domElem.click();
            expect(spy.calls.count()).toEqual(1);
        });
    });

    describe('#_state', function() {
        describe('_open', function() {
            it('выставление _state_open генерирует событие "open"', function() {
                var spy = jasmine.createSpy('spy');
                paranja.on('open', spy);

                paranja.setMod('state', 'open');

                expect(spy.calls.count()).toEqual(1);
            });
        });
        describe('_close', function() {
            it('выставление _state_close генерирует событие "close"', function() {
                var spy = jasmine.createSpy('spy');
                paranja.on('close', spy);

                paranja.setMod('state', 'open');
                paranja.setMod('state', 'close');

                expect(spy.calls.count()).toEqual(1);
            });
        });
    });

    afterEach(function(done) {
        BEM.DOM.afterCurrentEvent(function(){
            BEM.DOM.destruct(example.domElem);
            done();
        });
    });

    function build(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).bem(bemjson.block);
    }

});
