(function (BEM) {
    'use strict';
    /**
     * Блок `progress` – полоса загрузки, которая умеет растягиваться от 0 до 100%.
     */
    BEM.DOM.decl('progress', {

        /**
         * Обновить ширину полосы загрузки
         * @param {Number} value — новое значение ширины в интервале от 0 до 1
         * @param {String} [timing] — значение модификатора _timing который выставляется перед изменением шириныи определяет
         * анимацию изменения ширины. Новые значения модификатора можно добавлять на уровне сервиса по аналогии с linear
         * @returns {BEM.DOM}
         */
        update: function(value, timing) {
            this.setMod('timing', timing || '')
                .domElem
                .css({
                    width: value <= 0 ? '0'
                        : value >= 1 ? '100%'
                        : (value * 100).toPrecision(2) + '%'
                })
                .css('width'); /* В FF если вызвать метод дважды в одном тике, анимация второго вызова не принимает в расчёт
                                * значение установленное первым. Вызов css() в качестве геттера заставляет браузер
                                * применить стиль и анимация отрабатывает правильно.
                                */
            return this;
        }

    });
})(BEM);
