describe('progress', function() {
    'use strict';

    var progress,
        bemjson = {
            attrs: {style: 'width: 100px'},
            content: {block: 'progress'}
        };

    beforeEach(function() {
        progress = buildProgress(bemjson);
    });

    describe('#initial', function() {
        it('изначально ширина должна быть 0', function() {
            expect(progress.domElem.width()).toBe(0);
        });
    });

    describe('#API', function() {
        describe('update()', function() {
            it('должен устанавливать ширину блока', function() {
                progress.update(0.5);
                expect(progress.domElem.width()).toBe(50);
            });

            it('не должен устанавливать ширину блока вне границ 0–100%', function() {
                progress.update(-0.5);
                expect(progress.domElem.width()).toBe(0, 'минимальное значение — 0');
                progress.update(1.5);
                expect(progress.domElem.width()).toBe(100, 'максимальное значение — 100%');
            });

            it('должен устанавливать модификатор timing', function() {
                progress.update(1, 'linear');
                expect(progress.getMod('timing')).toBe('linear', 'линейная анимация');
                progress.update(0);
                expect(progress.getMod('timing')).toBe('', 'без анимации');
            });

            it('должен возвращать объект на котором вызван', function() {
                expect(progress.update(1, 'linear')).toBe(progress);
            });
        });
    });

    afterEach(function() {
        progress.domElem.parent().remove();
        BEM.DOM.destruct(progress.domElem);
    });

    function buildProgress(bemjson) {
        return BEM.DOM.init($(BEMHTML.apply(bemjson)).appendTo('body')).children().bem('progress');
    }

});
