(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'a-control',
        modName: 'lego',
        modVal: 'checkbox'
    }, {
        onSetMod: {
            checked: function (modName, modVal) {
                this._getControl().setMod(modName, modVal);
            }
        },

        /**
         * Переводит чекбокс в активное состояние (галочка нажата).
         *
         * @return {BEM.DOM}
         */
        check: function () {
            this._getControl().setMod('checked', 'yes');
            return this;
        },

        /**
         * Переводит чекбокс в неактивное состояние (галочка не нажата).
         *
         * @return {BEM.DOM}
         */
        uncheck: function () {
            this._getControl().delMod('checked');
            return this;
        },

        /**
         * Шоткат для проверки модификатора _checked_yes.
         *
         * @return {Boolean}
         */
        isChecked: function () {
            return this._getControl().isChecked();
        },

        /**
         * Возвращает имя нативного контрола.
         *
         * @return {String}
         */
        name: function () {
            return this._name ||
                (this._name = this._getControl().findElem('control').attr('name'));
        },

        /**
         * Хелпер для переключения модификатора _checked_yes.
         *
         * @return {BEM.DOM}
         */
        toggle: function () {
            this._getControl().toggle();
            return this;
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockInsideEvent('change', 'checkbox', function () {
                var checked = this._getControl().getMod('checked');
                this.setMod('checked', checked);

                this.isDisabled() ||
                    this.trigger('change', {checked: checked === 'yes'});
            });
        }
    });
})(BEM);
