(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'a-control',
        modName: 'lego',
        modVal: 'input'
    }, {
        /**
         * Очищает значение в поле ввода.
         * Генерирует событие change.
         *
         * @return {BEM.DOM}
         */
        clearInput: function () {
            this._getControl().clearInput();
            return this;
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockInsideEvent('ahead-click', 'input', function () {
                this.trigger('ahead-click');
            });

            this.liveInitOnBlockInsideEvent('blur', 'input', function () {
                this.trigger('blur');
            });

            this.liveInitOnBlockInsideEvent('change', 'input', function (e, data) {
                // Дополнительные данные, которые могут придти из метода val (второй аргумент).
                this.trigger('change', data);
            });

            this.liveInitOnBlockInsideEvent('focus', 'input', function () {
                this.trigger('focus');
            });

            this.liveInitOnBlockInsideEvent('select', 'input', function (e, data) {
                this.trigger('select', data);
            });

            this.liveInitOnBlockInsideEvent('update-items', 'input', function () {
                this.trigger('update-items');
            });
        }
    });
})(BEM);
