(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'a-control',
        modName: 'lego',
        modVal: 'radiobox'
    }, {
        /**
         * Метод позволяет получить активный элемент radio блока.
         *
         * @return {jQuery}
         */
        getCurrent: function () {
            return this._getControl().getCurrent();
        },
        /**
         * Возвращает имя нативного контрола.
         *
         * @return {String}
         */
        name: function () {
            return this._name ||
                (this._name = this._getControl().findElem('control').attr('name'));
        },
        /**
         * Метод позволяет перевести все кнопки блока в ненажатое состояние.
         *
         * @return {BEM.DOM}
         */
        uncheckAll: function () {
            var control = this._getControl();
            control.uncheckAll.apply(control, arguments);
            return this;
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockInsideEvent('change', 'radiobox', function (e, data) {
                this.trigger('change', data);
            });
        }
    });
})(BEM);
