(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'a-control',
        modName: 'lego',
        modVal: 'select'
    }, {
        /**
         * Возвращает true, если в данный момент выпадающий список элементов открыт.
         *
         * @return {Boolean}
         */
        isOpened: function () {
            return this._getControl().isOpened();
        },
        /**
         * Открывает выпадающий список.
         *
         * @return {BEM.DOM}
         */
        open: function () {
            this._getControl().open();
            return this;
        },
        /**
         * Закрывает выпадающий список.
         *
         * @return {BEM.DOM}
         */
        close: function () {
            this._getControl().close();
            return this;
        },
        /**
         * Возвращает имя нативного контрола.
         *
         * @return {String}
         */
        name: function () {
            return this._name ||
                (this._name = this._getControl().findElem('control').attr('name'));
        },
        /**
         * Перерисовывает выпадающий список.
         * Размеры списка будут подстроены под содержимое его элементов.
         *
         * @return {BEM.DOM}
         */
        redraw: function () {
            this._getControl().redraw();
            return this;
        },

        /**
         * Устанавливает новый набор опций.
         *
         * @return {BEM.DOM}
         */
        setOptions: function () {
            var control = this._getControl();
            control.setOptions.apply(control, arguments);
            return this;
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockInsideEvent('change', 'select', function (e, data) {
                this.trigger('change', data);
            });
        }
    });
})(BEM);
