(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'a-control',
        modName: 'lego',
        modVal: 'slider'
    }, {
        /**
         * Устанавливает минимально допустимое значение, если передан параметр min,
         * или возвращает текущее значение, если параметр не передан.
         *
         * @return {BEM.DOM|Number}
         */
        min: function () {
            var control = this._getControl();
            var result = control.min.apply(control, arguments);
            return arguments.length === 0 ? result : this;
        },
        /**
         * Устанавливает максимально допустимое значение, если передан параметр max,
         * или возвращает текущее значение, если параметр не передан.
         *
         * @return {BEM.DOM|Number}
         */
        max: function () {
            var control = this._getControl();
            var result = control.max.apply(control, arguments);
            return arguments.length === 0 ? result : this;
        },
        /**
         * Возвращает имя нативного контрола.
         *
         * @return {String}
         */
        name: function () {
            return this._name ||
                (this._name = this.findBlockInside('input').name());
        },
        /**
         * Устанавливает или возвращает диапазон допустимых значений.
         *
         * @param {Number} [min] Минимально допустимое значение.
         * @param {Number} [max] Максимально допустимое значение.
         *                       Если значение не передано или оно меньше min,
         *                       будет установлено максимально допусимое значение текущей шкалы.
         * @return {BEM.DOM|Array}
         */
        /* jshint unused:true */
        range: function (min, max) {
        /* jshint unused:false */
            var control = this._getControl();
            var result = control.range.apply(control, arguments);
            return arguments.length === 0 ? result : this;
        },
        /**
         * Возвращает ориентацию слайдера.
         *
         * @return {String} Возможные значения: 'vert'||'hor'.
         */
        getOrientation: function () {
            return this._getControl().getOrientation();
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockInsideEvent('dragend', 'slider', function () {
                this.trigger('dragend');
            });

            this.liveInitOnBlockInsideEvent('change', 'slider', function (e, data) {
                this.trigger('change', data);
            });
        }
    });
})(BEM);
