(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'a-control',
        modName: 'lego',
        modVal: 'tumbler'
    }, {
        onSetMod: {
            checked: function (modName, modVal) {
                this._getControl().setMod(modName, modVal);
            }
        },

        /**
         * Включает тумблер либо, если у тумблера заданы значения для переключения,
         * выбирает правый элемент option.
         *
         * @return {BEM.DOM}
         */
        check: function () {
            this._getControl().check();
            return this;
        },

        /**
         * Выключает тумблер либо, если у тумблера заданы значения для переключения,
         * выбирает левый элемент option.
         *
         * @return {BEM.DOM}
         */
        uncheck: function () {
            this._getControl().uncheck();
            return this;
        },

        /**
         * Получает состояние тумблера.
         *
         * @return {Boolean} Возвращает true, если тумблер включен, и false, если выключен.
         */
        isChecked: function () {
            return this._getControl().isChecked();
        },

        /**
         * Возвращает имя нативного контрола.
         * @return {String}
         */
        name: function () {
            return this._name ||
                (this._name = this._getControl().findElem('input').attr('name'));
        },

        /**
         * Переключает состояния тумблера включен-выключен, либо,
         * если у тумблера заданы значения для переключения,
         * переключает между левым и правым значением элемента option.
         *
         * @return {BEM.DOM}
         */
        toggle: function () {
            this._getControl().toggle();
            return this;
        }
    }, {
        live: function () {
            this.__base.apply(this, arguments);

            this.liveInitOnBlockInsideEvent('change', 'tumbler', function (e, data) {
                this.setMod('checked', data.checked ? 'yes' : '');
                this.trigger('change', data);
            });
        }
    });
})(BEM);
