(function (BEM) {
    'use strict';

    BEM.DOM.decl('example', {
        onSetMod: {
            js: function () {
                this.findBlocksInside('a-grid').forEach(function (grid) {
                    var place = grid.findElem('col').filter(':last-child');
                    var control = grid.findBlockInside('a-control');

                    control && control.on('change', function (e, data) {
                        if (typeof data === 'undefined') {
                            place.html('has changed');
                        } else {
                            try {
                                var str = JSON.stringify(data);
                                place.html(str);
                            } catch(z) {
                                place.html('has changed');
                                console.log(data);
                            }
                        }
                    });
                }, this);

                this.findBlockOn('name', 'button').on('click', function () {
                    this.findBlocksInside('a-grid').forEach(function (grid) {
                        var control = grid.findBlockInside('a-control');
                        var place = grid.findElem('col').filter(':last-child');

                        control && place.html(control.name());
                    });
                }, this);

                this.findBlockOn('val', 'button').on('click', function () {
                    this.findBlocksInside('a-grid').forEach(function (grid) {
                        var control = grid.findBlockInside('a-control');
                        var place = grid.findElem('col').filter(':last-child');

                        control && place.html(control.val());
                    });
                }, this);
            }
        }
    });
})(BEM);
