(function (BEM) {
    'use strict';

    BEM.DOM.decl('a-control', {
        onSetMod: {
            js: function () {
                this.hasMod('error', 'yes') && this.showError(this.params.error);
            },

            disabled: function (modName, modVal) {
                this._getControl().setMod(modName, modVal);
            }
        },

        destruct: function () {
            this._popup && this._popup.destruct();

            this.__base.apply(this, arguments);
        },

        /**
         * Проверяет, находится ли блок в отключенном состоянии.
         * Отключенное состояние характеризуется наличием модификатора _disabled_yes.
         *
         * @return {Boolean}
         */
        isDisabled: function () {
            return this.hasMod('disabled', 'yes');
        },

        /**
         * Прячет попап с ошибкой, если есть и удаляет модификатор _error_yes.
         *
         * @return {BEM.DOM}
         */
        hideError: function () {
            this.delMod('error');

            if (this._popup) {
                this.un('change', this.hideError, this);
                this._popup.hide();
            }

            return this;
        },

        /**
         * Показывает попап с описанием ошибки. При необходимости создает попап.
         * Ставит модификатор _error_yes.
         *
         * @param  {String}  msg Описание ошибки.
         * @return {BEM.DOM}
         */
        showError: function (msg) {
            this.hasMod('error', 'yes') || this.setMod('error', 'yes');

            if (!this._popup) {
                BEM.DOM.append(this.domElem, BEMHTML.apply({
                    block: 'popup',
                    mix: {block: 'a-control', elem: 'popup'},
                    js: {
                        directions: {
                            to: 'right',
                            offset: {left: 2}
                        }
                    },
                    content: [
                        {elem: 'tail'},
                        {elem: 'content', content: msg}
                    ]
                }));

                this._popup = this
                    .findBlockInside('popup')
                    .on('outside-click', function (e) {
                        e.preventDefault();
                    });
            } else {
                this._popup.setContent(msg);
            }

            this.on('change', this.hideError, this);
            this._popup.show(this.domElem);

            return this;
        },

        /**
         * Возвращает имя нативного контрола.
         *
         * @return {String}
         */
        name: function () {
            return this._getControl().name();
        },

        /**
         * Возвращает значение, если контрол не выключен.
         * Для сбора данных лучше использовать данный метод вместо метода val.
         *
         * @return {Any|null}
         */
        serialize: function () {
            return this.isDisabled() ? null : this.val();
        },

        /**
         * Устанавливает/возвращает текущее значение.
         *
         * @param  {String} [value] Устанавливаемое значение.
         * @param  {Object} [data]  Дополнительные данные, которые некоторые блоки умеют прокидывать
         *                          в обработчик события change (например input).
         * @return {String}
         */
        /* jshint unused:true */
        val: function (value, data) {
        /* jshint unused:false */
            var control = this._getControl();
            return control.val.apply(control, arguments);
        },

        /**
         * Возвращает ссылку на экземпляр леговского контрола.
         *
         * @return {Lego}
         */
        _getControl: function () {
            return this._control ||
                (this._control = this.findBlockInside(this.getMod('lego')));
        }
    }, {
        live: true
    });
})(BEM);
