### Описание

Проксирует леговские блоки и приводит их интерфейс к одному виду. Проксируемый блок выбирается одноименным значением модификатора `lego`.

### bemjson Api

В зависимости от выбранного блока (мод `lego`) принимаемые поля могут немного отличаться. Ниже подробный список.

#### checkbox

* *{String}* `id` Уникальный идентификатор блока.
* *{String}* `label` Текст, который будет отображен рядом с галкой.
* *{String}* `name` Значение атрибута `name`.
* *{String}* `value` Значение атрибута `value`.
* *{Number}* `tabindex`

#### input

* *{String}* `id` Уникальный идентификатор блока.
* *{String}* `name` Значение атрибута `name`.
* *{String}* `value` Значение атрибута `value`.
* *{Number}* `tabindex`

* *{String}* `accesskey` Значение `yes`.
* *{Number}* `cols`
* *{Number}* `rows`
* *{Number}* `maxlength`
* *{String}* `readonly` Значение `yes`.
* *{String}* `spellcheck` Включает режим проверки правописания. Возможные значения: `"true | false"`.

#### radio-button

* *{String}* `name` Значение атрибута `name`.
* *{String}* `value` Указывает выбранное значение.
* *{Array}* `options` Содержит набор объектов, которые описывают элементы.
* *{Object}* `options.*` Описывает элемент `radio`.
    * *{String}* `label` Задает текст кнопки.
    * *{String}* `disabled` Приминает значение `yes`. Отключает элемент.
    * *{String}* `id` Задает уникальный идентификатор.
    * *{Number}* `tabindex`
    * *{String}* `value` Задает значение атрибута `value`.

#### radiobox

* *{String}* `name` Значение атрибута `name`.
* *{String}* `value` Указывает выбранное значение.
* *{Array}* `options` Содержит набор объектов, которые описывают элементы.
* *{Object}* `options.*` Описывает элемент `radio`.
    * *{String}* `label` Задает текст кнопки.
    * *{String}* `disabled` Приминает значение `yes`. Отключает элемент.
    * *{String}* `id` Задает уникальный идентификатор.
    * *{Number}* `tabindex`
    * *{String}* `value` Задает значение атрибута `value`.

#### select

* *{String}* `label` Задает текст кнопки.
* *{String}* `id` Уникальный идентификатор блока.
* *{String}* `name` Значение атрибута `name`.
* *{Number}* `tabindex`
* *{String}* `value` Указывает выбранный элемент.
* *{Array}* `options` Формируют содержимое выпадающего списка.
* *{Object}* `options.*` Описывает элемент выпадающего списка.
    * *{String}* `label` Задает текст кнопки.
    * *{String}* `disabled` Приминает значение `yes`. Блокирует доступ к элементу списка.
    * *{String}* `value` Задает значение атрибута `value`.

#### slider

* *{String}* `name` Значение атрибута `name`.
* *{String}* `value` Указывает выбранный элемент.
* *{Number}* `min` Устанавливает `js` параметр `min` у лего блока `slider`.
* *{Number}* `max` Устанавливает `js` параметр `max` у лего блока `slider`.
* *{Array}* `options` Устанавливает `js` параметр `scale` у лего блока `slider`.

#### tumbler

* *{String}* `name` Значение атрибута `name`.
* *{Boolean}* `value` Задает начальное состояние блока (вкл/выкл).
* *{Object}* `on` Позволяет задать элемент `option` явно, соответствующий включенному состоянию. Альтернатива полю `options`.
* *{Object}* `off` Позволяет задать элемент `option` явно, соответствующий выключенному состоянию. Альтернатива полю `options`.
* *{Array}* `options` Позволяет задать элементы `option` данного блока. Их два. Первый соответствует полю `on`, второй - `off`.
* *{Object}* `options.*`
    * *{String}* `label` Текст, описывающий данное состояние.
    * *{String}* `value` Атрибут `value`.

### Объявление на странице

```
{
    block: 'a-control',
    mods: {lego: 'checkbox'},
    name: 'bro',
    value: 'Yandex'
}
```
