describe('a-control', function () {
    'use strict';

    var TIMEOUT = 5000;

    describe('метод hideError', function () {
        before(build({
            block: 'a-control',
            mods: {
                lego: 'input'
            },
            name: 'bro',
            tabindex: 0,
            value: 'yandex'
        }));

        after(destroy('a-control'));

        it('не выкидывает исключение', function () {
            var control = bem('a-control');

            control.hideError();
        });
    });

    describe('_error', function () {
        before(build({
            block: 'a-control',
            mods: {
                error: 'yes',
                lego: 'input'
            },
            error: 'So, what\'s happening?',
            name: 'bro',
            tabindex: 0,
            value: 'yandex'
        }));

        after(destroy('a-control'));

        it('блок содержит мод _error_yes', function () {
            document.querySelector('.a-control').classList.contains('a-control_error_yes').must.equal(true);
        });

        it('блок инициализирован', function () {
            document.querySelector('.a-control').classList.contains('a-control_js_inited').must.equal(true);
        });

        it('нарисован попап с ошибкой', function () {
            document.querySelector('.a-control__popup').classList.contains('popup_visibility_visible').must.equal(true);
        });

        it('текст ошибки соответствует тексту из поля error', function () {
            $('.popup__content').text().must.equal('So, what\'s happening?');
        });

        it('попап не закроется по событию outside-click', function () {
            $('<div id="my_test"></div>').appendTo('body');
            $('div#my_test').click();
            document.querySelector('.a-control__popup').classList.contains('popup_visibility_visible').must.equal(true);
            $('div#my_test').remove();
        });

        it('корректно работают методы hideError', function (done) {
            var control = bem('a-control');
            var popup = $('.a-control__popup').bem('popup');

            popup.on('hide', function () {
                this.afterCurrentEvent(function () {
                    popup.un('hide');
                    control.hasMod('error', 'yes').must.equal(false);
                    done();
                });
            });
            control.hideError();

            this.timeout(TIMEOUT);
        });

        it('корректно работают методы showError', function (done) {
            var control = bem('a-control');
            var popup = $('.a-control__popup').bem('popup');

            popup.on('show', function () {
                this.afterCurrentEvent(function () {
                    popup.un('show');
                    control.hasMod('error', 'yes').must.equal(true);
                    $('.popup__content').text().must.equal('test');
                    done();
                });
            });
            control.showError('test');

            this.timeout(TIMEOUT);
        });
    });

    describe('_lego', function () {
        describe('_checkbox', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'checkbox'},
                label: 'Ya.bro',
                name: 'bro',
                value: 'yandex'
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок checkbox', legoBlockInside.bind(null, 'a-control', 'checkbox'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'checkbox'));

            it('корректно ставится модификатор _checked_yes', function (done) {
                var control = bem('a-control');
                var checkbox = control._getControl();

                // Возвращаем чекбокс в начальное состояние и убираем мод _disabled_yes,
                // т.к. в этом режиме чекбокс не триггерит событие change.
                control.isDisabled() && control.delMod('disabled');
                control.hasMod('checked', 'yes') && control.delMod('checked', 'yes');

                control.on('change', function () {
                    control.hasMod('checked', 'yes').must.equal(true);
                    control
                        .un('change')
                        .on('change', function () {
                            control.hasMod('checked', 'yes').must.equal(false);
                            control.un('change');
                            done();
                        });

                    control.delMod('checked');
                });
                control.setMod('checked', 'yes');

                this.timeout(TIMEOUT);
            });

            it('корректно работает методы check, uncheck и isChecked', function () {
                var control = bem('a-control');
                var checkbox = control._getControl();

                control.isChecked() && control.uncheck();
                control.check();
                control.isChecked().must.equal(true);
                control.uncheck();
                control.isChecked().must.equal(false);
            });

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод toggle', function () {
                var control = bem('a-control');

                // Возвращаем чекбокс в начальное состояние и убираем мод _disabled_yes,
                // т.к. в этом режиме чекбокс не триггерит событие change.
                control.isDisabled() && control.delMod('disabled');
                control.hasMod('checked', 'yes') && control.delMod('checked', 'yes');

                control
                    .toggle()
                    .isChecked().must.equal(true);

                control
                    .toggle()
                    .isChecked().must.equal(false);
            });

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 'iexplorer'));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 'iexplorer', 'safari'));

            it('триггерит событие change', function (done) {
                var control = bem('a-control');
                var checkbox = control._getControl();

                // Возвращаем чекбокс в начальное состояние и убираем мод _disabled_yes,
                // т.к. в этом режиме чекбокс не триггерит событие change.
                control.isDisabled() && control.delMod('disabled');
                control.hasMod('checked', 'yes') && checkbox.delMod('checked', 'yes');

                control.on('change', function (e, data) {
                    data.checked.must.equal(true);
                    control.un('change');
                    done();
                });
                checkbox.setMod('checked', 'yes');

                this.timeout(TIMEOUT);
            });
        });

        describe('_input', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'input'},
                label: 'Ya.bro',
                name: 'bro',
                value: 'yandex'
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок input', legoBlockInside.bind(null, 'a-control', 'input'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'input'));

            it('корректно работает метод clearInput', function (done) {
                var control = bem('a-control');

                control.val('shlang');
                control.on('change', function () {
                    control.val().must.equal('');
                    control.un('change');
                    done();
                });
                control.clearInput();

                this.timeout(TIMEOUT);
            });

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 'iexplorer'));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 'iexplorer', 'safari'));

            it('триггерит событие ahead-click', function (done) {
                var control = bem('a-control');

                control.on('ahead-click', function () {
                    control.un('ahead-click');
                    done();
                });
                control._getControl().trigger('ahead-click');
            });

            it('триггерит событие change', function (done) {
                var control = bem('a-control');

                control.clearInput();
                control.on('change', function (e, data) {
                    data.msg.must.equal('yo');
                    control.un('change');
                    done();
                });
                control.val('test', {msg: 'yo'});

                this.timeout(TIMEOUT);
            });

            it('триггерит событие select', function (done) {
                var control = bem('a-control');

                control.on('select', function (e, data) {
                    control.un('select');
                    data.greetings.must.equal('hello');
                    done();
                });
                control._getControl().trigger('select', {greetings: 'hello'});
            });

            it('триггерит событие update-items', function (done) {
                var control = bem('a-control');

                control.on('update-items', function () {
                    control.un('update-items');
                    done();
                });
                control._getControl().trigger('update-items');
            });
        });

        describe('_radio-button', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'radio-button'},
                name: 'bro',
                value: 'yandex',
                options: [
                    {label: 'IE', value: 'iexplorer'},
                    {label: 'Ya', value: 'yandex'},
                    {label: 'Sa', value: 'safari'}
                ]
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок radio-button', legoBlockInside.bind(null, 'a-control', 'radio-button'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'radio-button'));

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 'iexplorer'));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 'iexplorer', 'safari'));

            it('триггерит событие change', function (done) {
                var control = bem('a-control');

                control.val('iexplorer');
                control.on('change', function () {
                    control.un('change');
                    done();
                });
                control.val('safari');

                this.timeout(TIMEOUT);
            });
        });

        describe('_radiobox', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'radiobox'},
                name: 'bro',
                value: 'yandex',
                options: [
                    {label: 'IE', value: 'iexplorer'},
                    {label: 'Ya', value: 'yandex'},
                    {label: 'Sa', value: 'safari'}
                ]
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок radiobox', legoBlockInside.bind(null, 'a-control', 'radiobox'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'radiobox'));

            it('корректно работает метод getCurrent', function () {
                var control = bem('a-control');

                control.val('safari');
                control.getCurrent().text().replace(/\s/g, '').must.equal('Sa');
            });

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод uncheckAll', function () {
                var control = bem('a-control');

                control.val('safari');
                control.uncheckAll();
                control.getCurrent().length.must.equal(0);
            });

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 'iexplorer'));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 'iexplorer', 'safari'));

            it('триггерит событие change', function (done) {
                var control = bem('a-control');

                control.val('iexplorer');
                control.on('change', function (e, data) {
                    data.current.text().replace(' ', '').must.equal('Sa');
                    data.prev.text().replace(' ', '').must.equal('IE');
                    control.un('change');
                    done();
                });
                control.val('safari');

                this.timeout(TIMEOUT);
            });
        });

        describe('_select', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'select'},
                name: 'bro',
                value: 'yandex',
                options: [
                    {label: 'IE', value: 'iexplorer'},
                    {label: 'Ya', value: 'yandex'},
                    {label: 'Sa', value: 'safari'}
                ]
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок select', legoBlockInside.bind(null, 'a-control', 'select'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'select'));

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 'iexplorer'));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 'iexplorer', 'safari'));

            it('корректно работает методы open, close, isOpened', function () {
                var control = bem('a-control');

                control.isOpened() && control.close();
                control.open();
                control.isOpened().must.equal(true);
                control.close();
                control.isOpened().must.equal(false);
            });

            it('корректно работает метод setOptions', function () {
                var control = bem('a-control');

                control.setOptions([
                    {item: 'option', value: 'M', content: 'Москва'},
                    {item: 'option', value: 'SP', content: 'Санкт-Петербург'},
                    {item: 'option', value: 'K', content: 'Красноярск'}
                ]);

                var options = control._getControl().findElem('option');

                options.length.must.equal(3);
                options[0].value.must.equal('M');
                options[1].value.must.equal('SP');
                options[2].value.must.equal('K');

                control.setOptions([
                    {item: 'option', content: 'IE', value: 'iexplorer'},
                    {item: 'option', content: 'Ya', value: 'yandex'},
                    {item: 'option', content: 'Sa', value: 'safari'}
                ]);
            });

            it('триггерит событие change', function (done) {
                var control = bem('a-control');

                control.val('iexplorer');
                control.on('change', function (e, data) {
                    data.index.must.equal(2);
                    data.prev.must.equal(0);
                    control.un('change');
                    done();
                });
                control.val('safari');

                this.timeout(TIMEOUT);
            });

            it('корректно работает метод redraw', function () {
                var control = bem('a-control');
                control.redraw();
                var items = control._getControl()._items;
                items.eq(0).text().must.be.eql('IE');
                items.eq(1).text().must.be.eql('Ya');
                items.eq(2).text().must.be.eql('Sa');
            });
        });

        describe('_slider', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'slider'},
                name: 'bro',
                tabindex: 0,
                value: 10,

                min: 10,
                max: 90,
                options: [
                    {value: 0, step: 10},
                    {value: 100}
                ]
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок slider', legoBlockInside.bind(null, 'a-control', 'slider'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'slider'));

            it('корректно работает метод getOrientation', function () {
                var control = bem('a-control');

                control.getOrientation().must.equal('hor');
            });

            it('корректно работает метод min', function () {
                var control = bem('a-control');

                control.min(15).must.equal(control);
                control.min().must.equal(15);
            });

            it('корректно работает метод max', function () {
                var control = bem('a-control');

                control.max(95).must.equal(control);
                control.max().must.equal(95);
            });

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод range', function () {
                var control = bem('a-control');

                control.range(20, 80).must.equal(control);
                control.range()[0].must.equal(20);
                control.range()[1].must.equal(80);
            });

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 20));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 20, 10));

            it('триггерит событие dragend', function (done) {
                var control = bem('a-control');

                control.on('dragend', function () {
                    control.un('dragend');
                    done();
                });
                control._getControl().trigger('dragend');
            });
        });

        describe('_tumbler', function () {
            before(build({
                block: 'a-control',
                mods: {lego: 'tumbler'},
                name: 'bro',
                options: [
                    {label: 'IE', value: 'iexplorer'},
                    {label: 'Ya', value: 'yandex'}
                ]
            }));

            after(destroy('a-control'));

            it('внутри есть лего блок tumbler', legoBlockInside.bind(null, 'a-control', 'tumbler'));

            it('корректно ставится модификатор _disabled_yes', disabledTest.bind(null, 'a-control', 'tumbler'));

            it('корректно ставится модификатор _checked_yes', function () {
                var control = bem('a-control');

                control.isChecked() && control.uncheck();
                control.setMod('checked', 'yes');
                control.isChecked().must.equal(true);
                control.delMod('checked');
                control.isChecked().must.equal(false);
            });

            it('корректно работает методы check, uncheck, isChecked', function () {
                var control = bem('a-control');

                control.check().must.equal(control);
                control.isChecked().must.equal(true);
                control.uncheck().must.equal(control);
                control.isChecked().must.equal(false);
            });

            it('корректно работает метод name', nameTest.bind(null, 'a-control', 'bro'));

            it('корректно работает метод toggle', function () {
                var control = bem('a-control');

                control.uncheck();
                control.toggle();
                control.isChecked().must.equal(true);
                control.toggle();
                control.isChecked().must.equal(false);
            });

            it('корректно работает метод serialize', serializeTest.bind(null, 'a-control', 'iexplorer'));

            it('корректно работает метод val', valTest.bind(null, 'a-control', 'iexplorer', 'yandex'));

            it('триггерит событие change', function (done) {
                var control = bem('a-control');

                control.on('change', function (e, data) {
                    control.un('change');
                    data.checked.must['boolean']();
                    done();
                });
                control.toggle();
            });
        });
    });

    function legoBlockInside(blockName, legoBlockName) {
        document.querySelectorAll('.' + blockName + ' .' + legoBlockName).length.must.above(0);
    }

    function disabledTest(blockName, legoBlockName) {
        var control = bem(blockName);

        control.setMod('disabled', 'yes');
        control.isDisabled().must.equal(true);
        control.domElem.hasClass(blockName + '_disabled_yes').must.equal(true);
        control._getControl().domElem.hasClass(legoBlockName + '_disabled_yes').must.equal(true);

        control.delMod('disabled');
        control.isDisabled().must.equal(false);
        control.domElem.hasClass(blockName + '_disabled_yes').must.equal(false);
        control._getControl().domElem.hasClass(legoBlockName + '_disabled_yes').must.equal(false);
    }

    function nameTest(blockName, name) {
        var control = bem(blockName);

        control.name().must.equal(name);
    }

    function serializeTest(blockName, val) {
        var control = bem(blockName);

        control.val(val);
        control.serialize().must.equal(val);
        control.setMod('disabled', 'yes');
        (control.serialize() === null).must.equal(true);
        control.delMod('disabled');
    }

    function valTest(blockName, val1, val2) {
        var control = bem(blockName);

        control.val(val1);
        control.val().must.equal(val1);
        control.val(val2);
        control.val().must.equal(val2);
    }

    function bem(blockName) {
        return $('.' + blockName).bem(blockName);
    }

    function build(json) {
        return function () {
            BEM.DOM.append('body', BEMHTML.apply(json));
        };
    }

    function destroy(blockName) {
        return function () {
            BEM.DOM.destruct($('.' + blockName));
        };
    }
});
