(function (BEM) {
    'use strict';

    /**
     * Возможные JS параметры:
     *
     * autoLoad {Boolean} нужно ли загружать форму сразу
     * url {String} адрес, по которому можно получить форму
     * sendUrl {String} адрес, куда данные формы отправляются
     *
     * События:
     *
     * cleared: очистка блока
     * loading: началась загрузка формы
     * loaded: загружена форма
     * error: ошибка
     * errors: ошибки полей
     *
     */
    BEM.DOM.decl('a-form-ajax', {
        onSetMod: {
            js: function () {
                if (this.params.autoLoad) {
                    this.setMod('loaded', 'pending');
                } else {
                    this.setMod('loaded', 'no');
                }
            },

            disabled: {
                yes: function () {
                    if (this._form) {
                        this._form.findBlocksInside('b-form-button').forEach(function (b) {
                            b.setMod('disabled', 'yes');
                        });
                    }
                },

                // триггер на удаление простого модификатора disabled
                '': function () {
                    if (this._form) {
                        this._form.findBlocksInside('b-form-button').forEach(function (b) {
                            b.delMod('disabled');
                        });
                    }
                }
            },

            loaded: {
                yes: function () {
                    this.trigger('update');
                },

                pending: function () {
                    var url = this.params.url;

                    this._showSpin();
                    this.__self.load(url)
                        .success(this._onLoad.bind(this))
                        .error(this._onError.bind(this));
                    this.trigger('update');
                },

                no: function () {
                    this._form && this._form.destruct();
                    this._form = null;
                    this._hideSpin();
                    this.trigger('cleared');
                }
            }
        },

        clear: function () {
            this._hideError();
            this._form && this._form.hideErrors();
            this.setMod('loaded', 'no');
        },

        load: function () {
            this._hideError();
            this.setMod('loaded', 'pending');
        },

        _hideSpin: function () {
            var spin = this.findBlockInside('spin');

            if (spin) {
                spin.destruct();
            }
        },

        _showSpin: function () {
            BEM.DOM.update(this.domElem, BEMHTML.apply({
                block: 'spin',
                js: true,
                mods: {
                    progress: 'yes',
                    theme: 'gray-32'
                }
            }));
        },

        // Рисуется около кнопки формы "Отправить"
        _showSmallSpin: function () {
            var submitButton = $('input[type=submit]', this.domElem).parents('.b-form-button');

            if (submitButton) {
                BEM.DOM.after(submitButton, BEMHTML.apply({
                    block: 'spin',
                    js: true,
                    mods: {
                        progress: 'yes',
                        theme: 'gray-16'
                    }
                }));
            }
        },

        // Удаляет общую ошибку
        _hideError: function () {
            var error = this.findBlockInside('b-form-error');

            if (error) {
                error.destruct();
            }
        },

        // Показывает общую ошибку
        _showError: function (text) {
            BEM.DOM.prepend(this.domElem, BEMHTML.apply({
                block: 'b-form-error',
                content: text
            }));
        },

        // Загружена форма
        _onLoad: function (data) {
            BEM.DOM.update(this.domElem, BEMHTML.apply(data));
            this._form = this.findBlockInside('b-form');

            if (!this._form) {
                return;
            }

            var form = $('form', this.domElem);
            form.submit(this._onSubmit.bind(this, form));
            this.setMod('loaded', 'yes');
        },

        // Данные формы загружены на сервер
        // Вариант ответа с ошибками:
        // {"error":null,"field_errors":{"phone":"Обязательное поле"}}
        _onUpload: function (data) {
            this._hideSpin();
            this.delMod('disabled');

            if (data.error) {
                this._showError(data.error);
                this.trigger('update');
            } else if (data.field_errors) {
                var fields = $('.b-form-input', this._form.domElem);
                var field;

                for (var k in data.field_errors) {
                    field = fields.has('input[name="' + k + '"]').bem('b-form-input');
                    field.setMod('notification', 'error');
                    field.showNotification(data.field_errors[k]);
                }
            }

            data.action === 'close' &&
                this.trigger('close');
        },

        _onUploadError: function (e) {
            this._hideSpin();
            this.delMod('disabled');
            this._showError(e.status === 0 ? BEM.I18N('a-form-ajax', 'No data') : e.statusText);
            this.trigger('update');
        },

        // Ошибка, возникающая при загрузке формы
        _onError: function (e) {
            this._showError(e.status === 0 ? BEM.I18N('a-form-ajax', 'No data') : e.statusText);
            this.setMod('loaded', 'no');
            this.trigger('update');
        },

        // Отправка формы
        _onSubmit: function (form, e) {
            e.preventDefault();
            var url = this.params.sendUrl || form.attr('action') || this.params.url;
            var data = form.serialize();

            if (!data) {
                return;
            }

            this.setMod('disabled', 'yes');
            this._form && this._form.hideErrors();
            this._hideError();
            this._showSmallSpin();
            this.__self.send(url, data)
                .success(this._onUpload.bind(this))
                .error(this._onUploadError.bind(this));
        }
    }, {
        load: function (url) {
            return $.getJSON(url, {ajax: 1});
        },

        send: function (url, data) {
            url += (url.indexOf('?') > 0 ? '&' : '?') + 'ajax=1';
            data += '&ajax=1';
            return $.post(url, data);
        }
    });
})(BEM);
