describe('a-grid', function () {
    'use strict';
    describe('Использование шорткатов', function () {
        before(build);
        after(destroy);

        it('блок содержит 4 колонки', function () {
            querySelector('.a-grid__col').length.must.equal(4);
        });

        it('колонка 1 содержит мод _percent в значении 1', function () {
            querySelector('.a-grid__col')[0].classList.contains('a-grid__col_percent_1').must.equal(true);
        });

        it('колонка 2 содержит мод _percent-offset в значении 2', function () {
            querySelector('.a-grid__col')[1].classList.contains('a-grid__col_percent-offset_2').must.equal(true);
        });

        it('колонка 3 содержит мод _fixed в значении 220', function () {
            querySelector('.a-grid__col')[2].classList.contains('a-grid__col_fixed_220').must.equal(true);
        });

        it('колонка 4 содержит мод _fixed-offset в значении 220', function () {
            querySelector('.a-grid__col')[3].classList.contains('a-grid__col_fixed-offset_220').must.equal(true);
        });

        it('колонка 4 содержит заданный текст', function () {
            querySelector('.a-grid__col')[3].innerHTML.must.equal('Колонка 4');
        });
    });

    function build() {
        BEM.DOM.append('body', BEMHTML.apply({
            block: 'a-grid',
            cols: [
                {percent: 1, content: 'Колонка 1'},
                {percent: 1, 'percent-offset': 2, content: 'Колонка 2'},
                {fixed: 220, content: 'Колонка 3'},
                {fixed: 220, 'fixed-offset': 220, content: 'Колонка 4'}
            ]
        }));
    }

    function destroy() {
        BEM.DOM.destruct($('.a-grid'));
    }

    function querySelector(selector) {
        return document.querySelectorAll(selector);
    }
});
