(function (BEM, window) {
    'use strict';

    var storage = require('utils/storage');

    BEM.DOM.decl('a-layout', {
        onSetMod: {
            js: function () {
                this._primaryNavigation = this.findBlockInside(this.elem('nav', 'type', 'primary'), 'a-navigation');
                if (this._primaryNavigation) {
                    this._primaryNavigation.on('item-change', this._onItemChanged, this);
                }

                var hideNav = storage.getItem('hideNav') || '';
                this.setMod('nav-hidden', hideNav === 'yes' ? 'yes' : '');

                this.elem('hide-button').on('click', this._onHideClicked.bind(this));
            },
            'nav-hidden': function (modName, modVal) {
                storage.setItem('hideNav', modVal);
                this.afterCurrentEvent(this._triggerWindowResize, this);
            }
        },

        _renderSecondaryNav: function () {
            if (!this._primaryNavigation) {
                return;
            }

            var navUtil = require('utils/navigation');
            var nav = this.params.navigation;
            var url = this._primaryNavigation.getSelectedUrl() || this._primaryNavigation.getActiveUrl();

            var secondary = navUtil.getSecondaryBemjson(nav, url);
            if (secondary) {
                secondary.mix = [{block: 'a-layout', elem: 'nav', elemMods: {type: 'secondary'}}];
                var currentSecondary = this.findElem('nav', 'type', 'secondary');
                if (currentSecondary.length !== 0) {
                    BEM.DOM.replace(currentSecondary, BEMHTML.apply(secondary));
                } else {
                    BEM.DOM.before(this.elem('main'), BEMHTML.apply(secondary));
                    this._triggerWindowResize();
                }
                this.setMod('levels', 3);
                return false;
            } else if (!secondary && url === this._primaryNavigation.getActiveUrl()) {
                BEM.DOM.destruct(this.findElem('nav', 'type', 'secondary'));
                this._triggerWindowResize();
                this.setMod('levels', 2);
                return false;
            }
            return true;
        },

        _onItemChanged: function (e, data) {
            if (!this._primaryNavigation) {
                return;
            }

            var clickedUrl = data.clickedUrl;
            var prevUrl = data.prevUrl;
            if (this._renderSecondaryNav(clickedUrl, prevUrl)) {
                this._primaryNavigation.deselectAll();
            } else {
                data.originalEvent.preventDefault();
            }
        },

        _onHideClicked: function () {
            this.toggleMod('nav-hidden', 'yes');
        },

        _triggerWindowResize: function () {
            var doc = window.document;
            var e = null;
            if (doc.createEvent) {
                e = doc.createEvent('HTMLEvents');
                e.initEvent('resize', true, true);
            } else if (doc.createEventObject){
                e = doc.createEventObject();
                e.eventType = 'resize';
            }
            e.eventName = 'resize';
            if (window.dispatchEvent){
                window.dispatchEvent(e);
            } else if (window.fireEvent) {
                window.fireEvent('on' + e.eventType, e);
            }
        }
    });
})(BEM, window);
