(function (BEM, BEMHTML) {
    'use strict';
    describe('a-layout', function () {
        var block = null;
        var storage = require('utils/storage');

        var initHideNav = Boolean(storage.getItem('hideNav'));
        beforeEach(function () {
            BEM.DOM.append('body', BEMHTML.apply({
                block: 'a-layout',
                content: 'Content',
                navigation: [
                    {
                        type: 'item',
                        name: 'first-level-group',
                        url: 'url',
                        active: 1
                    },
                    {
                        type: 'group',
                        name: 'one-more-first-level-group',
                        url: 'one-more-url',
                        items: [{
                            type: 'group',
                            name: 'one-more-second-level-group',
                            items: [
                                {
                                    type: 'item',
                                    name: 'one-more-third-level-item',
                                    url: 'one-more-url',
                                    items: [{
                                        type: 'item',
                                        name: 'one-more-fourth-level-item'
                                    }]
                                }
                            ]
                        }]
                    }
                ]
            }));
            block = $('.a-layout').bem('a-layout');
        });

        afterEach(function () {
            BEM.DOM.destruct($('.a-layout'));
        });

        describe('#initial', function () {
            it('Не должен иметь модификатора nav-hidden', function () {
                block.hasMod('nav-hidden').must.be.eql(initHideNav);
            });
        });

        describe('#_nav-hidden', function () {
            it('Должен устанавливаться по клику на элемент hide-button', function () {
                $('.a-layout__hide-button').click();
                block.hasMod('nav-hidden').must.be.eql(!initHideNav);
            });
        });

        describe('Private', function () {
            describe('._triggerWindowResize()', function () {
                it('Должен триггерить событие resize', function () {
                    var resized = false;
                    $(window).on('resize', function () {
                        resized = true;
                    });
                    block._triggerWindowResize();
                    resized.must.be.eql(true);
                });
            });

            describe('._renderSecondaryNav()', function () {
                it('Должен рендерить второго уровня для выбранного итема', function () {
                    $('.link').eq(1).click();
                    $('.a-navigation_type_secondary').must.have.length(1);
                });

                it('Должен возвращать исходное меню при повторном клике', function () {
                    $('.link').eq(1).click();
                    $('.link').eq(1).click();
                    $('.a-navigation_type_secondary').must.have.length(0);
                });
            });
        });
    });
})(BEM, BEMHTML);
