(function (BEM) {
    'use strict';

    BEM.DOM.decl({block: 'a-navigation', modName: 'type', modVal: 'primary'}, {
        getUrl: function ($item) {
            if (!$item || $item.length === 0) {
                return '';
            }
            return this.findBlockInside($item, 'link').domElem.attr('href');
        },

        getSelectedUrl: function () {
            var $item = this.elem('item', 'selected', 'yes');
            return this.getUrl($item);
        },

        getActiveUrl: function () {
            var $item = this.elem('item', 'active', 'yes');
            return this.getUrl($item);
        },

        deselectAll: function () {
            this.delMod(this.elem('item'), 'selected');
        },

        _onItemClick: function (e) {
            var _this = this;
            var clickedUrl = $(e.target).attr('href');
            var prevUrl = this.getSelectedUrl();

            var items = this.elem('item');
            items.toArray().forEach(function (item) {
                var $item = $(item);
                var linkUrl = _this.getUrl($item);
                if (linkUrl === clickedUrl && linkUrl !== prevUrl) {
                    _this.setMod($item, 'selected', 'yes');
                } else {
                    _this.delMod($item, 'selected');
                }
            });

            this.trigger('item-change', {originalEvent: e, clickedUrl: clickedUrl, prevUrl: prevUrl});
        }
    }, {
        live: function () {
            this.liveBindTo('item', 'leftclick', function (e) {
                this._onItemClick(e);
            });
        }
    });
})(BEM);
