(function (BEM, BEMHTML) {
    'use strict';
    describe('a-navigation', function () {
        beforeEach(function () {
            BEM.DOM.append('body', BEMHTML.apply({
                block: 'a-navigation',
                mods: {type: 'primary'},
                js: 'true',
                content: [
                    {
                        block: 'a-navigation',
                        elem: 'item',
                        content: 'first-item',
                        url: 'firstUrl',
                        elemMods: {active: ''}
                    },
                    {
                        block: 'a-navigation',
                        elem: 'item',
                        content: 'second-item',
                        url: 'secondUrl',
                        elemMods: {active: 'yes'}
                    }
                ]
            }));
        });

        afterEach(function () {
            BEM.DOM.destruct($('.a-navigation'));
        });

        describe('#initial', function () {
            it('изначально не должен инициализироваться', function () {
                $('.a-navigation').hasClass('a-navigation_js_inited').must.be.eql(false);
            });
        });

        describe('#live', function () {
            it('должен инициализироваться по клику на элементе item', function () {
                $('.link').eq(0).click();
                $('.a-navigation').hasClass('a-navigation_js_inited').must.be.eql(true);
            });
        });

        describe('API', function () {
            var block = null;
            beforeEach(function () {
                block = $('.a-navigation').bem('a-navigation');
            });

            describe('Methods', function () {
                describe('.getUrl($item)', function () {
                    it('должен возвращать url по $item', function () {
                        var $item = $('.link').eq(0);
                        block.getUrl($item).must.be.eql('firstUrl');
                    });
                });

                describe('.getSelectedUrl()', function () {
                    it('должен возвращать url выбранного элемента меню', function () {
                        $('.link').eq(0).click();
                        block.getSelectedUrl().must.be.eql('firstUrl');
                    });
                });

                describe('.getActiveUrl()', function () {
                    it('должен возвращать активный url', function () {
                        block.getActiveUrl().must.be.eql('secondUrl');
                    });
                });

                describe('.deselectAll()', function () {
                    it('должен сбрасывать выделение со всех итемов меню', function () {
                        $('.link').eq(0).click();
                        block.deselectAll();
                        $('.a-navigation__item_selected_yes').must.have.length(0);
                    });
                });
            });

            describe('Events', function () {
                describe('item-changed', function () {
                    it('должно срабатывать при смене выбранного итема меню', function () {
                        var result = null;
                        block.on('item-change', function (e, data) {
                            result = data;
                        });
                        $('.link').eq(0).click();
                        result.clickedUrl.must.be.eql('firstUrl');
                        result.prevUrl.must.be.eql('');
                    });
                });
            });
        });
    });
})(BEM, BEMHTML);
