/*globals Lego*/
/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module for display data in any format.
*
*/

(function() {
    'use strict';

    var dateStringFormat = /(\d{4})-(\d{1,2})-(\d{1,2})/,
        formats = {
            ru: {
                month: {
                    'short': [
                        'янв', 'фев', 'мар', 'апр', 'мая', 'июн',
                        'июл', 'авг', 'сен', 'окт', 'ноя', 'дек'
                    ],
                    'long': [
                        'января', 'февраля', 'марта', 'апреля', 'мая', 'июня',
                        'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'
                    ]
                }
            },
            en: {
                month: {
                    'short': [
                        'jan', 'feb', 'mar', 'apr', 'may', 'jun',
                        'jul', 'aug', 'sep', 'oct', 'nov', 'dec'
                    ],
                    'long': [
                        'january', 'february', 'march', 'april', 'may', 'june',
                        'july', 'august', 'september', 'october', 'november', 'december'
                    ]
                }
            },
            tr: {
                month: {
                    'short': [
                        'oca', 'şub', 'mar', 'nis', 'may', 'haz',
                        'tem', 'ağu', 'eyl', 'eki', 'kas', 'ara'
                    ],
                    'long': [
                        'ocak', 'şubat', 'mart', 'nisan', 'mayıs', 'haziran',
                        'temmuz', 'ağustos', 'eylül', 'ekim', 'kasım', 'aralık'
                    ]
                }
            }
        };

    function render(d, args) {
        args || (args = {});

        var localizedFormats = formats[Lego.params.locale] || formats.en;
        var month = localizedFormats.month[args.len || 'short'];
        var dateParts = [];

        // is timestatmp
        if (typeof d == 'number') {
            var date = new Date;

            date.setTime(d);

            d = date;
        }
        if (d instanceof Date) {
            // is date

            dateParts =  [d.getUTCFullYear(), month[d.getUTCMonth()], d.getUTCDate()];
        } else {
            // is string
            var ps = dateStringFormat.exec(d);

            if (ps) {
                dateParts = [ps[3], month[ps[2] - 1], ps[1]];
            }
        }

        if ((this.params && this.params.year === false) || args.year === false) {
            dateParts.pop();
        }

        return dateParts.join(args.separator || '&nbsp;');
    }

    var formatter = BEM.DOM.prototype.formatContent;

    formatter.date = function() {
        return render.apply({}, arguments);
    };

    BEM.DOM.decl({block: 'b-formatter', modName: 'type', modVal: 'date'}, {
        render: render
    });

})();
