/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module for display data in any format.
*
*/

(function() {

    function render(d, o) {
        var content = 1 * d;

        if (isNaN(content)) {
            content = d;
        } else {
            content = content.toFixed((o && o.precision) || 4).replace('.', ',');
        }

        return content;
    }

    var formatter = BEM.DOM.prototype.formatContent;

    formatter['float'] = function() {
        return render.apply({}, arguments);
    }

    BEM.DOM.decl({ block: 'b-formatter', modName: 'type', modVal: 'float' }, {
        render: render
    });

})();
