/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module for display data in any format.
*
*/

(function () {
    'use strict';
    var currencies = {
        RUB: {
            block: 'i-font',
            mods: {face: 'rub-arial-regular'},
            tag: 'span',
            content: 'Р'
        },
        USD: '$',
        EUR: '€'
    };

    var inlineCurrencies = {
        RUB: {
            tag: 'span',
            attrs: {
                style: 'font-family: \'rub-arial-regular\''
            },
            content: 'Р'
        },
        USD: '$',
        EUR: '€'
    };

    function render(d, args) {
        var currency;
        if (typeof d == 'object') {
            currency = d.currency;
            d = d.value;
        } else {
            currency = 'RUB'; // fallback to legacy
        }

        if (d == '-') {
            return d;
        }

        if (typeof d == 'string') {
            d = parseFloat(d);
        }

        d = d.toFixed(2).replace('.', ',');

        var currencySign = currencies[currency];
        if (args.style === 'inline') {
            currencySign = inlineCurrencies[currency];
        }

        return [
            formatter(d.toString(), 'number', args) + ' ',
            currencySign
        ];
    }

    var formatter = BEM.DOM.prototype.formatContent;

    formatter.money = function () {
        return render.apply({}, arguments);
    };

    BEM.DOM.decl({block: 'b-formatter', modName: 'type', modVal: 'money'}, {
        render: render
    });

})();
