/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module for display data in any format.
*
*/

(function() {

    var sep = {
        en: '.',
        ru: ','
    };

    function thousandSeparate(v, o) {
        var r = /(-?[0-9]+)([0-9]{3})/;
        while ( r.test(v) ) {
            v = v.replace(r, '$1' + ((o && o.separator) || '&nbsp;')  + '$2');
        }
        v = v.replace(',', sep[Lego.params.locale] || '.');
        return v;
    }

    function render(d, o) {
        return thousandSeparate(d.toString(), o);
    }

    var formatter = BEM.DOM.prototype.formatContent;

    formatter.number = function() {
        return render.apply({}, arguments);
    }

    BEM.DOM.decl({ block: 'b-formatter', modName: 'type', modVal: 'number' }, {
        render: render
    });

})();
