/**
*
* @author Ilya Rezvov <irezvov@yandex-team.ru>
* @date 2012
* @description Module for display data in any format.
*
*/

(function() {

var fmt = BEM.DOM.prototype.formatContent = function(content, type, args) {
    var ft = fmt[type] || function(d) { return d; };
    return ft(content, args);
}

var xmlEscape = function( string ) {
    return string
        .replace(/&/g, "&amp;")
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;")
        .replace(/"/g, "&quot;");
};

BEM.DOM.decl('b-formatter', {
    onSetMod: {
        js: function() {
            if ( this.params.data != null ) {
                this.update(this.render(this.params.data));
            }
        }
    },

    /**
     * @public
     * Render data to display value
     *
     * @param data Data for rendering
     * @return {BEMJSON}
     */
    render: function(d) {
        return xmlEscape(d);
    },

    /**
     * @public
     * Update formatter content
     *
     * @param {BEMJSON} content Content in BEMJSON format
     */
    update: function(bemjson) {
        var html = '';
        if ( typeof bemjson == 'object' ) {
            html = BEMHTML.apply(bemjson);
        }
        else {
            html = bemjson;
        }
        // convert to string, need for numbers
        BEM.DOM.update(this.domElem, html);
        return html;
    }

});

})();
