(function (BEM) {
    'use strict';

    BEM.DOM.decl({
        block: 'i-glue-field_type_a-control',
        baseBlock: 'i-glue-field'
    }, {
        /**
         * Инициализирует блок i-glue-field
         *
         * @protected
         */
        init: function () {
            this.__base.apply(this, arguments);

            this.getControl().on('change', function (e, data) {
                if (this.getType() === 'checkbox' || this.getType() === 'tumbler') {
                    this.name.split(' ').forEach(function (name) {
                        this.model.set(name, data.checked);
                    }, this);
                } else {
                    this.name.split(' ').forEach(function (name) {
                        this.model.set(name, this.getControl().val());
                    }, this);
                }
            }, this);
        },

        /**
         * Выставить значение поля модели
         *
         * @param {*} val Значение поля
         */
        set: function (value) {
            this.__base();

            if (this.getType() === 'checkbox' || this.getType() === 'tumbler') {
                this.getControl().setMod('checked', value ? 'yes' : '');
            } else {
                this.getControl().val(data.value);
            }
        },

        /**
         * Выполнить действие по изменению поля модели.
         *
         * @param {Object} e
         * @param {Object} data
         */
        onFieldChange: function (e, data) {
            if (this.getType() === 'checkbox' || this.getType() === 'tumbler') {
                this.getControl().setMod('checked', data.value ? 'yes' : '');
            } else {
                this.getControl().val(data.value);
            }
        },

        /**
         * Кэширует и возвращает ссылку на контрол.
         *
         * @return {BEM.DOM}
         */
        getControl: function () {
            return this.control ||
                (this.control = this.findBlockOn('a-control'));
        },

        /**
         * Кэширует и возвращает тип контрола.
         *
         * @return {String}
         */
        getType: function () {
            return this.type ||
                (this.type = this.getControl().getMod('lego'));
        }
    });
})(BEM);
