describe('i-glue-field_type_a-control', function () {
    'use strict';

    var model;

    before(function () {
        BEM.MODEL.decl('glue-field-a-control-model', {
            checkbox: 'boolean',
            tumbler: 'boolean',
            input: 'string'
        });
    });

    describe('_lego_checkbox', function () {
        beforeEach(function () {
            BEM.DOM.append('body', BEMHTML.apply({
                block: 'glued-field',
                mix: {
                    block: 'i-glue',
                    js: {
                        modelName: 'glue-field-a-control-model',
                        modelData: {
                            checkbox: false
                        }
                    }
                },
                content: [
                    {
                        block: 'a-control',
                        mods: {
                            lego: 'checkbox'
                        },
                        mix: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                name: 'checkbox',
                                type: 'a-control'
                            }
                        }
                    }
                ]
            }));

            model = $('.glued-field').bem('i-glue').model;
        });

        afterEach(function () {
            BEM.DOM.destruct($('.glued-field'));
        });

        it('сеттится через модель', function (done) {
            var checkbox = $('.a-control_lego_checkbox').bem('a-control');

            checkbox.on('change', function (e, data) {
                checkbox.un('change');
                data.checked.must.be(true);

                done();
            });

            model.set('checkbox', true);
        });

        it('сеттит поле в модели', function (done) {
            var checkbox = $('.a-control_lego_checkbox').bem('a-control');

            model.on('checkbox', 'change', function () {
                model.un('checkbox', 'change');
                model.get('checkbox').must.be(true);

                done();
            });

            checkbox.check();
        });
    });

    describe('_lego_tumbler', function () {
        beforeEach(function () {
            BEM.DOM.append('body', BEMHTML.apply({
                block: 'glued-field',
                mix: {
                    block: 'i-glue',
                    js: {
                        modelName: 'glue-field-a-control-model',
                        modelData: {
                            tumbler: false
                        }
                    }
                },
                content: [
                    {
                        block: 'a-control',
                        mods: {
                            lego: 'tumbler'
                        },
                        mix: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                name: 'tumbler',
                                type: 'a-control'
                            }
                        },
                        options: [
                            {label: 'no'},
                            {label: 'yes'}
                        ]
                    }
                ]
            }));

            model = $('.glued-field').bem('i-glue').model;
        });

        afterEach(function () {
            BEM.DOM.destruct($('.glued-field'));
        });

        it('сеттится через модель', function (done) {
            var tumbler = $('.a-control_lego_tumbler').bem('a-control');

            tumbler.on('change', function (e, data) {
                tumbler.un('change');
                data.checked.must.be(true);

                done();
            });

            model.set('tumbler', true);
        });

        it('сеттит поле в модели', function (done) {
            var tumbler = $('.a-control_lego_tumbler').bem('a-control');

            model.on('tumbler', 'change', function () {
                model.un('tumbler', 'change');
                model.get('tumbler').must.be(true);

                done();
            });

            tumbler.check();
        });
    });

    describe('_lego_input', function () {
        beforeEach(function () {
            BEM.DOM.append('body', BEMHTML.apply({
                block: 'glued-field',
                mix: {
                    block: 'i-glue',
                    js: {
                        modelName: 'glue-field-a-control-model',
                        modelData: {
                            input: '45'
                        }
                    }
                },
                content: [
                    {
                        block: 'a-control',
                        mods: {
                            lego: 'input'
                        },
                        mix: {
                            block: 'i-glue',
                            elem: 'model-field',
                            js: {
                                name: 'input',
                                type: 'a-control'
                            }
                        },
                        value: '45'
                    }
                ]
            }));

            model = $('.glued-field').bem('i-glue').model;
        });

        afterEach(function () {
            BEM.DOM.destruct($('.glued-field'));
        });

        it('сеттится через модель', function (done) {
            var input = $('.a-control_lego_input').bem('a-control');

            input.on('change', function () {
                input.un('change');
                input.val().must.be('125');

                done();
            });

            model.set('input', '125');
        });

        it('сеттит поле в модели', function (done) {
            var input = $('.a-control_lego_input').bem('a-control');

            model.on('input', 'change', function () {
                model.un('input', 'change');
                model.get('input').must.be('215');

                done();
            });

            input.val('215');
        });
    });
});
