(function (BEM) {
    'use strict';

    /**
     * Независимые поля:
     *
     * @field {kit}
     * @field {lang}
     * @field {tab}
     * @field {winList}
     * @field {winType}
     *
     * Зависимые поля:
     *
     * @field {page}
     * @field {win}
     * @field {winState}
     * @field {winTypes}
     */
    BEM.MODEL.decl('m-instruction', {
        /**
         * Выбранный комплект.
         *
         * @type {Number}
         */
        kit: {
            type: 'number',
            default: 0
        },

        /**
         * Выбранный язык инсталятора.
         *
         * @type {String} ru|tr
         */
        lang: {
            type: 'string',
            default: 'ru'
        },

        /**
         * Показываемая страница.
         *
         * @type {String}
         */
        page: {
            type: 'string',
            calculate: function () {
                var kit = this.get('kit');

                return kit ? 'rear' : 'front';
            },
            dependsFrom: ['kit']
        },

        /**
         * Выбранная вкладка табов.
         *
         * @type {Number}
         */
        tab: {
            type: 'number',
            default: 1
        },

        /**
         * Выбранное окно, которое будет показано.
         *
         * @type {String}
         */
        win: {
            type: 'string',
            calculate: function () {
                var kit = this.get('kit');
                var tab = this.get('tab');
                var type = this.get('winType');

                return kit === 3 ? type.split(' ')[tab - 1] : type;
            },
            dependsFrom: ['tab', 'winType']
        },

        /**
         * Список чекбоксов.
         *
         * @type {Models-List}
         */
        winList: {
            type: 'models-list',
            modelName: 'm-checkbox'
        },

        winState: {
            type: 'string',
            calculate: function () {
                var list = this.get('winList');
                var falsy = 0;
                var state = '';

                list.forEach(function (model) {
                    var checked = model.get('checked');

                    checked || falsy++;
                    state += String(Number(checked));
                });

                return falsy ? state : '';
            },
            dependsFrom: 'winList'
        },

        /**
         * Выбранный тип окон.
         *
         * @type {String}
         */
        winType: 'string',

        /**
         * Типы окон.
         * Также выставит начальное значение поля `winType`.
         *
         * @type {String}
         */
        winTypes: {
            type: 'number',
            calculate: function () {
                var kit = this.get('kit');
                var winType;

                switch (kit) {
                case 1:
                    winType = 'abc-ya';
                    break;

                case 2:
                    winType = 'abc-ya-bro';
                    break;

                case 3:
                    winType = 'abc-ya ya-bro';
                    break;

                case 4:
                    winType = 'ya-bro';
                    break;

                default:
                    winType = '';
                }

                this.set('winType', winType);

                return kit !== 4 ? kit : 0;
            },
            dependsFrom: 'kit'
        }
    });
})(BEM);
