describe('m-instruction', function () {
    'use strict';

    var model = BEM.MODEL.create('m-instruction');

    describe('page', function () {
        it('равно "rear", если kit = [1; 4]', function () {
            model.set('kit', 1);
            model.get('page').must.be('rear');

            model.set('kit', 2);
            model.get('page').must.be('rear');

            model.set('kit', 3);
            model.get('page').must.be('rear');

            model.set('kit', 4);
            model.get('page').must.be('rear');
        });

        it('равно "front", если kit == 0', function () {
            model.set('kit', 0);
            model.get('page').must.be('front');
        });
    });

    describe('win', function () {
        before(function () {
            model.set('kit', 3);
            model.set('winType', 'abc-ya-bro');
            model.set('winType', 'abc-ya ya-bro');
        });

        it('равно "abc-ya", если kit = 3 и tabs = 1', function () {
            model.set('tab', 1);
            model.get('win').must.be('abc-ya');
        });

        it('равно "ya-bro", если kit = 3 и tabs = 2', function () {
            model.set('tab', 2);
            model.get('win').must.be('ya-bro');
        });
    });

    describe('winState', function () {
        it('равно "10101", соответствует состоянию моделек в поле winList', function () {
            model.set('winList', [
                {checked: true, value: 'a'},
                {checked: false, value: 'b'},
                {checked: true, value: 'c'},
                {checked: false, value: 'd'},
                {checked: true, value: 'e'}
            ]);

            model.get('winState').must.be('10101');
        });

        it('равно "", если у всех моделек в поле winList поле checked = true', function () {
            model.set('winList', [
                {checked: true, value: 'a'},
                {checked: true, value: 'b'},
                {checked: true, value: 'c'},
                {checked: true, value: 'd'},
                {checked: true, value: 'e'}
            ]);

            model.get('winState').must.be('');
        });
    });

    describe('winType', function () {
        it('равно "", если kit был установлен в значение 0', function () {
            model.set('kit', 0);
            model.get('winType').must.be('');
        });

        it('равно "abc-ya", если kit был установлен в значение 1', function () {
            model.set('kit', 1);
            model.get('winType').must.be('abc-ya');
        });

        it('равно "abc-ya-bro", если kit был установлен в значение 2', function () {
            model.set('kit', 2);
            model.get('winType').must.be('abc-ya-bro');
        });

        it('равно "abc-ya ya-bro", если kit был установлен в значение 3', function () {
            model.set('kit', 3);
            model.get('winType').must.be('abc-ya ya-bro');
        });

        it('равно "ya-bro", если kit был установлен в значение 4', function () {
            model.set('kit', 4);
            model.get('winType').must.be('ya-bro');
        });
    });

    describe('winTypes', function () {
        it('равно 0, если kit = {0, 4}', function () {
            model.set('kit', 0);
            model.get('winTypes').must.be(0);

            model.set('kit', 4);
            model.get('winTypes').must.be(0);
        });

        it('равно 1, если kit = 1', function () {
            model.set('kit', 1);
            model.get('winTypes').must.be(1);
        });

        it('равно 2, если kit = 2', function () {
            model.set('kit', 2);
            model.get('winTypes').must.be(2);
        });

        it('равно 3, если kit = 3', function () {
            model.set('kit', 3);
            model.get('winTypes').must.be(3);
        });
    });
});
