'use strict';

BEM.DOM.decl({block: 'user', modName: 'menu', modVal: 'pi-yes'}, {

    onSetMod: {

        js: function() {

            var _this = this,
                win = BEM.DOM.win;

            _this.__base.apply(_this, arguments);

            /* dropdown-menu доступен только залогиненым. */
            _this._dropdown = _this.findBlockOutside('dropdown-menu') || 0;

            _this._hide = _this._hide.bind(_this);

            _this._dropdown && _this._dropdown
                .on('show', function() {
                    win.on('scroll', _this._hide);
                })
                .on('hide', function() {
                    win.off('scroll', _this._hide);
                });

        }

    },

    _hide: function() {
        this._dropdown && this._dropdown.hide();
    },

    _onClick: function(e) {

        e.preventDefault();

        this.__base.apply(this, arguments);

        this._dropdown && this._dropdown
            .toggle( this.elem('icon').length ?
                     this.elem('icon') : this.elem('name') );

    },

    redraw: function() {

        this.__base.apply(this, arguments);
        if (!this._dropdown) {
            return this;
        }

        /* После асинхронной загрузки страницы нужно подставить новый
         * retpath для выхода. */

        /* FIXME */

        var Glob = BEM.blocks['i-global'],
            retpath = Glob.param('retpath'),
            yu = Glob.param('yandexuid'),

            logout_url = [
                Glob.param('passport-host'),
                '/passport?mode=logout',
                yu ? '&yu=' + yu : '',
                retpath ? '&retpath=' + encodeURIComponent(retpath) : ''
            ].join('');

        this._dropdown._popup
            .findBlockInside('user')
            .elem('logout')
            .attr('href', logout_url);

        return this;

    }

}, {

    live: function() {

        this.liveBindTo('leftclick', function(e) {
            this._onClick(e);
        });

        return false;
    }

});
