/*global __dirname, process*/
/*jshint laxbreak:true*/
'use strict';

/**
 * См. exports в конце файла
 */

//////////////////////////////////////////////////////////////////

var fs = require('fs');
var path = require('path');

function oldPaths(x) {
    return [
        path.join(x, 'blocks-common'),
        path.join(x, 'blocks-desktop')
    ];
}

function newPaths(x) {
    return [
        path.join(x, 'common.blocks'),
        path.join(x, 'desktop.blocks')
    ];
}

function concat(a, b) {
    return a.concat(b);
}

function prepend(p) {
    return function (x) {
        return path.join(p, x);
    };
}

var mapToCurrentDir = prepend(__dirname);

/**
 * Путь к блокам Лего
 * @type {[type]}
 */
var legoPath = fs.existsSync(mapToCurrentDir('lego'))
    ? mapToCurrentDir('lego')
    : '/var/lib/yandex/lego';

/**
 * Путь к блокам QBit
 * @type {[type]}
 */
var qbitPath = mapToCurrentDir('../lib');

var mapToQBitPath = prepend(qbitPath);

//////////////////////////////////////////////////////////////////

/**
 * Пути к библиотекам блоков "Ромочки"
 * @type {Array}
 */
var blocksRomochka = [
    '/bem-bl-1.1.1',
    '/romochka-2.10.26'
];
/**
 * Пути к островным библиотекам
 * @type {Array}
 */
var blocksIslands = [
    '/islands-page-2.0.0',
    '/islands-icons-1.9.0',
    '/islands-search-2.0.0',
    '/islands-components-2.1.0',
    '/islands-services-2.0.0',
    '/islands-user-2.0.0'
];

/**
 * Пути к промо-блокам
 */
var blocksIslandsPromo = [
    '/islands-promo-1.3.0'
];

/**
 * Пути к блокам QBit'а
 * @type {Array}
 */
var blocksQBit = [
    mapToQBitPath('QBit/blocks')
];

var blocksBemMvc = [
    mapToCurrentDir('bower_components/bem-mvc/common.blocks')
];

/**
 * Пути к локальным блокам проекта
 * @type {Array}
 */
var blocksPI = [
    mapToCurrentDir('../blocks'),
    mapToCurrentDir('blocks.lego'),
    mapToCurrentDir('blocks.pi')
];

/**
 * Пути к локальным блока для промо страниц
 * @type {Array}
 */
var blocksPromo = [
    mapToCurrentDir('../blocks'),
    mapToCurrentDir('blocks.pi'),
    mapToCurrentDir('blocks.promo')
];

/**
 * Уровни переопределения - "Ромочка", "Острова", блоки QBit/Yandex, блоки проекта
 * @type {Object}
 */
exports.levels = {
    romochka: blocksRomochka.map(prepend(legoPath)).map(oldPaths).reduce(concat),
    islands: blocksIslands.map(prepend(legoPath)).map(newPaths).reduce(concat),
    islandsPromo: blocksIslandsPromo.map(prepend(legoPath)).map(newPaths).reduce(concat),
    qbit: blocksQBit,
    bemMvc: blocksBemMvc,
    priv: blocksPI,
    privPromo: blocksPromo
};

exports.testLevels = [
    mapToCurrentDir('.cov/blocks.pi'),
    mapToCurrentDir('.cov/blocks.lego')
];

exports.allLevels = [].concat(exports.levels.romochka,
                              exports.levels.islands,
                              exports.levels.islandsPromo,
                              exports.levels.qbit,
                              exports.levels.bemMvc,
                              exports.levels.priv,
                              exports.levels.privPromo);

exports.allTestJsLevels = [].concat(exports.levels.romochka,
                              exports.levels.islands,
                              exports.levels.islandsPromo,
                              exports.levels.qbit,
                              exports.levels.bemMvc,

                              [mapToCurrentDir('../blocks')],
                              exports.testLevels);

exports.allTestDepsLevels = [].concat(exports.levels.romochka,
                              exports.levels.islands,
                              exports.levels.islandsPromo,
                              exports.levels.qbit,
                              exports.levels.bemMvc,

                              mapToCurrentDir('../blocks'),
                              mapToCurrentDir('blocks.pi'),
                              mapToCurrentDir('blocks.lego'));

exports.commonLevels = [].concat(exports.levels.romochka,
                              exports.levels.islands,
                              exports.levels.qbit,
                              exports.levels.bemMvc,
                              exports.levels.priv);

exports.promoLevels = [].concat(exports.levels.romochka,
                              exports.levels.islands,
                              exports.levels.islandsPromo,
                              exports.levels.qbit,
                              exports.levels.bemMvc,
                              exports.levels.privPromo);

/**
 * Пути к шаблонам
 * @type {Array}
 */
exports.allTemplates = [
    mapToQBitPath('QBit/templates'),
    mapToCurrentDir('../templates')
];

exports.promoTemplates = [
    mapToCurrentDir('../templates/main/advnet.bem.tt2'),
    mapToCurrentDir('../templates/main/pi.bem.tt2'),
    mapToCurrentDir('../templates/common/page/feedback.bem.tt2')
];

exports.clientTemplates = [
    mapToQBitPath('QBit/templates/common/form'),
    mapToQBitPath('QBit/templates/common/form.bem.tt2'),
    mapToCurrentDir('../templates/common/form'),
    mapToCurrentDir('../templates/common/client_blocks.bem.tt2'),
    mapToCurrentDir('../templates/common/page')
];

/**
 * Надо ли сжимать js и css файлы
 * @type {boolean}
 */
exports.minimize = process.env.COMPRESSED == 'false' ? false : true;

/**
 * devMode у enb-bemhtml. Значение true сильно замедляет рендеринг HTML
 * @type {boolean}
 */
exports.devMode = !exports.minimize;

/**
 * Используемые языки
 * @type {Array}
 */
exports.languages = ['ru', 'en', 'tr'];

/**
 * Выходные пути
 * @type {Object}
 */
exports.outPath = {
    img: mapToCurrentDir('../data/i/blocks'),
    css: mapToCurrentDir('../data/css'),
    js: mapToCurrentDir('../data/js'),
    priv: mapToCurrentDir('../') // где должен находиться common.priv.js
};
