/**
 * Модуль реализующий API для взаимодействия клиентского кода с серверным
 *
 * Методы должны возвращать промисы
 * http://promisesaplus.com/
 * https://github.com/dfilatov/vow
 */
'use strict';

exports.getBEMJSON = getBEMJSON;
exports.getStatisticData = getStatisticData;
exports.getStatisticWidgetInternalCampaignData = getStatisticWidgetInternalCampaignData;
exports.post = post;

var vow = require('vow');
var vowAjax = require('utils/vow-ajax');

function getBEMJSON(url) {
    return vowAjax.getJSON(url);
}

/**
 * Тащит данные для статистики.
 *
 * @param  {Array}   confs
 * @return {Promise}
 */
function getStatisticData(confs) {
    var url = '/statistics/query';

    return vow.all(confs.map(function (conf) {
        return post(url, conf);
    }));
}

/**
 * Тащит данные для статистики для виджетов по внутренним площадкам.
 *
 * @param  {Array}   confs
 * @return {Promise}
 */
function getStatisticWidgetInternalCampaignData(confs) {
    var url = '/statistics/widget_internal_context_campaign_query';

    return vow.all(confs.map(function (conf) {
        return post(url, conf);
    }));
}

/**
 * Шоркат для забора данных в статистике.
 *
 * @param  {String}  url
 * @param  {Object}  conf
 * @return {Promise}
 */
function post(url, conf) {
    return vowAjax.ajax({
        type: 'POST',
        url: url,
        dataType: 'json',
        data: {
            params: JSON.stringify(conf)
        }
    });
}