/**
 * Модуль реализующий фэйк сервер
 *
 */
'use strict';

exports.create = createFS;

var sinonsFakeServer = require('sinon').fakeServer;

/**
 * Возвращает сконфигурированный sinon's fakeServer
 *
 * @param {Array|Object} [routes]
 * @param {Number} [delay]
 */
function createFS(routes, delay) {
    var server = sinonsFakeServer.create();

    Array.isArray(routes) || (routes = [routes]);

    server.respondWith(function (request) {
        var involvedRoutes = routes
            .filter(function (route) {
                return route.url === request.url;
            });

        if (involvedRoutes.length) {
            involvedRoutes = involvedRoutes[0];

            request.respond(200, headers(involvedRoutes.contentType), involvedRoutes.response);
        } else {
            request.respond(404, headers(), 'Not found');
        }
    });

    server.autoRespond = true;
    delay && (server.autoRespondAfter = delay);

    return server;
}

/**
 * @param {String} [mediaType] По умолчанию `text/plain`
 */
function headers(mediaType) {
    return {'Content-Type': mediaType || 'text/plain'};
}
