/*globals alert,console*/
'use strict';

exports.info = error;
exports.warn = error;
exports.error = error;

/**
 * Предполагается, что если в функция используется в качестве обработки ошибок модуля vow-ajax,
 * то в качестве аргумента придется jqXHR объект.
 *
 * @param  {object} message
 */
function error(err) {
    var msg;

    if (err !== null && typeof err === 'object' && err.hasOwnProperty('status')) {
        if (err.status) {
            msg = err.statusText;
        } else {
            msg = 'Network connection error';
        }

        console.warn('status ' + err.status, err);
    } else {
        msg = err;
        console.error(err);
    }

    alert(msg);
}
