/**
 * Небольшой модуль, реализующий jQuery ajax методы через vow промисы
 *
 * Поддерживаемые методы
 *
 * * `ajax`
 * * `get`
 * * `getJSON`
 * * `post`
 *
 */
(function (exports) {
    'use strict';

    var vow = require('vow');
    var jQuery = require('jQuery');

    var fn = typeof vow.defer === 'function' ?
        newPromisify :
        oldPromisify;

    ['ajax', 'get', 'getJSON', 'post'].forEach(function (m) {
        exports[m] = (function (m) {
            return function () {
                return fn(m, arguments);
            };
        })(m);
    });

    /**
     * Описание API Vow
     *
     * @version 0.3.x
     * @link https://github.com/dfilatov/vow/blob/0.3.x/README.md
     */
    function oldPromisify(method, args) {
        var promise = vow.promise();

        /* http://api.jquery.com/jQuery.ajax/ */
        jQuery[method].apply(jQuery, args)
            .done(function (data) {
                promise.fulfill(data);
            })
            .fail(function (jqXHR) {
                promise.reject(jqXHR);
            });

        return promise;
    }

    /**
     * Описание API Vow
     *
     * @version 0.4.x
     * @link https://github.com/dfilatov/vow
     */
    function newPromisify(method, args) {
        var deffered = vow.defer();

        /* http://api.jquery.com/jQuery.ajax/ */
        jQuery[method].apply(jQuery, args)
            .done(function (data) {
                deffered.resolve(data);
            })
            .fail(function (jqXHR) {
                deffered.reject(jqXHR);
            });

        return deffered.promise();
    }
})(exports);
