describe('utils/chart', function () {
    'use strict';

    var chart = require('utils/chart');
    var cdate = require('utils/dates').CDate;

    describe('getColor', function () {
        it('вернет цвет по индексу', function () {
            /^#[a-f0-9]{6}$/i.test(chart.getColor(4)).must.be(true);
        });

        it('если указан еще номер отчета, то увеличин насыщенность цвета', function () {
            /^#[a-f0-9]{6}$/i.test(chart.getColor(4), 1).must.be(true);
        });
    });

    describe('getMaxColumns', function () {
        it('вернет константу', function () {
            chart.getMaxColumns().must.be.number();
        });
    });

    describe('getMaxLines', function () {
        it('вернет константу', function () {
            chart.getMaxLines().must.be.number();
        });
    });

    describe('formatAxis', function () {
        it('с валютой', function () {
            chart.formatAxis({
                title: 'abs',
                type: 'a'
            }).must.be.eql({
                extraValues: {},
                label: 'abs',
                type: 'a'
            });
        });

        it('без валюты', function () {
            chart.formatAxis({
                currency: 'usd',
                title: 'abs',
                type: 'a'
            }).must.be.eql({
                extraValues: {
                    entity_field: {
                        currency: 'usd'
                    }
                },
                label: 'abs',
                type: 'a'
            });
        });
    });

    describe('formatNumber', function () {
        it('отобьет тысячи пробелами', function () {
            chart.formatNumber(1120000).must.be('1 120 000');
        });

        it('округлит деньги до двух значимых чисел после запятой', function () {
            chart.formatNumber(12000.123, true).must.be('12 000,12');
        });
    });

    describe('formatPeriod', function () {
        it('форматирует периоды', function () {
            chart.formatPeriod(['2014-01-01', '2014-01-05', '2014-02-02', '2014-02-07']).must.be.eql([
                cdate('2014-01-01').format('DD MMM YY') + ' - ' + cdate('2014-01-05').format('DD MMM YY'),
                cdate('2014-02-02').format('DD MMM YY') + ' - ' + cdate('2014-02-07').format('DD MMM YY')
            ]);
        });
    });

    describe('formatSeries', function () {
        it('форматирует', function () {
            chart.formatSeries({
                data: ['some_data'],
                diff: false,
                index: 5,
                period: 'whut?',
                title: 'asd',
                yAxes: 3
            }).must.be.eql({
                color: chart.getColor(5, 0),
                data: ['some_data'],
                name: 'asd',
                type: null
            });
        });
    });

    describe('formatTitle', function () {
        it('если не указаны ограничения, то вернет заголовок как есть', function () {
            chart.formatTitle('asb').must.be('asb');
        });

        it('добавит переносы строк, если строка превышает указанную длину', function () {
            chart.formatTitle('qwerty uiop aa', 7).must.be('qwerty<br/>uiop aa');
        });
    });
});
