describe('utils/colors', function () {
    'use strict';

    var colors = require('utils/colors');

    describe('getColorByIndex()', function () {
        it('Вернет цвет', function () {
            /^#[a-f0-9]{6}$/i.test(colors.getColorByIndex(5)).must.be(true);
        });
    });

    describe('highlight()', function () {
        it('Без параметров увеличивает яркость цвета на 10%.', function () {
            colors.highlight('#336699').toLowerCase().must.be('#3870a8');
        });

        it('Увеличит яркость в два раза.', function () {
            colors.highlight('#336699', 2).toLowerCase().must.be('#b3cce6');
        });
    });
});
