'use strict';
describe('utils/control', function () {
    var control = require('utils/control');

    describe('getSelectedLabel()', function () {
        it('если не передан value, вернет свойство label первого элемента в массиве', function () {
            var options = [
                {value: 'val-1', label: 'lb-1'},
                {value: 'val-2', label: 'lb-2'},
                {value: 'val-3', label: 'lb-3'}
            ];

            control.getSelectedLabel(options).must.equal('lb-1');
        });

        it('если передан value, вернет свойство label элемента с соответствующим свойством value', function () {
            var options = [
                {value: 'val-1', label: 'lb-1'},
                {value: 'val-2', label: 'lb-2'},
                {value: 'val-3', label: 'lb-3'}
            ];

            control.getSelectedLabel(options, 'val-3').must.equal('lb-3');
        });
    });

    describe('getSelectItemsBemjson()', function () {
        it('должен вернуть массив __option для select', function () {
            var options = control.getSelectItemsBemjson([
                {value: 'test-value-1', label: 'test-label-1', disabled: 'yes'},
                {value: 'test-value-2', label: 'test-label-2'}
            ]);

            options.must.have.length(2);
            options.must.be.eql([
                {
                    elem: 'option',
                    attrs: {value: 'test-value-1', disabled: 'disabled'},
                    content: 'test-label-1'
                },
                {
                    elem: 'option',
                    attrs: {value: 'test-value-2'},
                    content: 'test-label-2'
                }
            ]);
        });

        it('должен вернуть массив __option для select, второй должен быть selected', function () {
            var options = control.getSelectItemsBemjson([
                {value: 'test-value-1', label: 'test-label-1'},
                {value: 'test-value-2', label: 'test-label-2'}
            ], 'test-value-2');

            options.must.have.length(2);
            options.must.be.eql([
                {
                    elem: 'option',
                    attrs: {value: 'test-value-1'},
                    content: 'test-label-1'
                },
                {
                    elem: 'option',
                    attrs: {value: 'test-value-2', selected: 'selected'},
                    content: 'test-label-2'
                }
            ]);
        });
    });

    describe('getRadioButtonItemsBemjson()', function () {
        it('должен вернуть список __radio', function () {
            var options = [
                {label: 'test-label-1', value: 'test-value-1', tabindex: 1, disabled: 'yes'},
                {label: 'test-label-2', value: 'test-value-2', tabindex: 1, id: 'test-id'}
            ];
            control.getRadioButtonItemsBemjson(options).must.be.eql([
                {
                    elem: 'radio',
                    elemMods: {disabled: 'yes'},
                    controlAttrs: {value: 'test-value-1', tabindex: 1},
                    content: 'test-label-1'
                },
                {
                    elem: 'radio',
                    controlAttrs: {value: 'test-value-2', tabindex: 1, id: 'test-id'},
                    content: 'test-label-2'
                }
            ]);
        });
    });

    describe('getRadioboxItemsBemjson()', function () {
        it('должен вернуть список __radio', function () {
            var options = [
                {
                    value: 'test-value-1',
                    label: 'test-label-1',
                    disabled: 'yes',
                    tabindex: 1
                },
                {
                    value: 'test-value-2',
                    label: 'test-label-2',
                    id: 'test-id'
                },
                {
                    value: 'test-value-3',
                    label: 'test-label-3',
                    tabindex: 1
                }
            ];

            control.getRadioboxItemsBemjson(options).must.be.eql([
                {
                    elem: 'radio',
                    controlAttrs: {
                        value: 'test-value-1',
                        tabindex: 1
                    },
                    elemMods: {
                        disabled: 'yes'
                    },
                    content: 'test-label-1'
                },
                {
                    elem: 'radio',
                    controlAttrs: {
                        value: 'test-value-2',
                        id: 'test-id'
                    },
                    content: 'test-label-2'
                },
                {
                    elem: 'radio',
                    controlAttrs: {
                        value: 'test-value-3',
                        tabindex: 1
                    },
                    content: 'test-label-3'
                }
            ]);
        });
    });
});
