describe('utils/data', function () {
    'use strict';

    var data = require('utils/data');
    var vow = require('vow');
    var server;

    before(function () {
        server = require('utils/fakeserver').create({
            url: 'json',
            contentType: 'application/json',
            response: JSON.stringify({tag: 'div', content: 'hello'})
        });
    });

    after(function () {
        server.restore();
    });

    describe('.getBEMJSON', function () {
        it('должен возвращать vow промис', function () {
            vow.isPromise(data.getBEMJSON('json')).must.equal(true);
        });

        it('должен возвращать BEMJSON', function (done) {
            data.getBEMJSON('json').then(function (bemjson) {
                bemjson.must.be.an.object();
                bemjson.must.have.property('tag', 'div');
                bemjson.must.have.property('content', 'hello');
                done();
            });
        });
    });
});
