'use strict';
/*jshint maxlen:false*/
describe('utils/fakeserver', function () {
    var ajax = require('utils/vow-ajax');
    var sinonFS = require('utils/fakeserver');
    var server;

    describe('.create()', function () {
        it('должен отдавать экземпляр созданного сервера, у которого есть метод .restore()', function () {
            server = sinonFS.create();
            server.restore.must.be.a.function();
            server.restore();
        });
    });

    describe('фэйковый сервер', function () {
        afterEach(function () {
            server.restore();
        });

        it('должен корректно обрабатывать запросы', function (done) {
            this.timeout(50);
            server = sinonFS.create({
                url: '/test',
                response: 'Ok'
            });

            ajax.get('/test').then(function (data) {
                data.must.be('Ok');
                done();
            });
        });

        it('должен отдавать 404 на несуществующие ссылки', function (done) {
            this.timeout(50);
            server = sinonFS.create({
                url: '/test',
                response: 'Ok'
            });

            ajax.get('/not-a-test')
                .fail(function (xhr) {
                    xhr.statusText.must.be('Not Found');
                    done();
                });
        });

        it('должен отдавать ответ с задержкой', function (done) {
            this.timeout(100);
            var timeStart = new Date().getTime();
            var timeEnd;

            server = sinonFS.create({
                url: '/test',
                response: 'Ok'
            }, 50);

            ajax.get('/test').then(function (reason) {
                timeEnd = new Date().getTime();

                reason.must.be('Ok');
                (timeEnd - timeStart).must.be.above(49);

                done();
            });
        });
    });
});
