'use strict';
/*jshint maxlen:false*/
describe('utils/vow-ajax', function () {
    var ajax = require('utils/vow-ajax');
    var sinonFS = require('utils/fakeserver');
    var server;

    describe('.ajax', function (done) {
        server = sinonFS.create({
            url: '/test',
            response: 'ok'
        });

        ajax.ajax({
            url: '/test'
        }).then(function (data) {
            data.must.be('ok');
            done();
        });

        server.restore();
        this.timeout(50);
    });

    describe('.get', function (done) {
        server = sinonFS.create({
            url: '/test',
            response: 'ok'
        });

        ajax.get('/test').then(function (data) {
            data.must.be('ok');
            done();
        });

        server.restore();
        this.timeout(50);
    });

    describe('.getJSON', function (done) {
        server = sinonFS.create({
            url: '/test',
            response: JSON.stringify({isOk: 'ok'})
        });

        ajax.getJSON('/test').then(function (data) {
            data.must.be.an.object();
            data.must.have.property('isOk', 'ok');
            done();
        });

        server.restore();
        this.timeout(50);
    });

    describe('.post', function (done) {
        server = sinonFS.create({
            url: '/test',
            response: 'ok'
        });

        ajax.get('/test').then(function (data) {
            data.must.be('ok');
            done();
        });

        server.restore();
        this.timeout(50);
    });
});
