package API;

use qbit;

use base qw(QBit::HTTPAPI QBit::WebInterface::FastCGI WebInterface::HTTPS Application);

use API::Method::Statistics2 path => 'statistics2';
use API::Method::Check path       => 'check';

__PACKAGE__->config_opts(api_location => 'api');

sub build_response {
    my ($self) = @_;

    $ENV{SYSTEM} = 'api';

    if ($self->request->scheme() eq 'http') {
        my $methods = $self->get_methods();
        my ($path, $method);
        {
            # Ugly hack: опции не скопированы, т.к. Application::pre_run ещё не вызван
            local ($self->{'__OPTIONS__'}) = clone($self->{'__ORIG_OPTIONS__'});
            ($path, $method) = $self->get_method();
        }

        unless ($methods->{$path}{$method}{'attrs'}{'ALLOWHTTP'}) {
            $self->response(QBit::WebInterface::Response->new());
            $self->response->status(301);
            $self->response->location($self->get_https_url());
            return;
        }
    }

    return $self->SUPER::build_response();
}

TRUE;
