
=encoding UTF-8

=cut

package Application;

use Cwd qw(cwd);
use Net::INET6Glue::INET_is_INET6;
use qbit;
use Utils::DB;
use Scalar::Util ();
use Log::Log4perl;
use Utils::Logger;
use Utils::MonitoringUtils;
use Time::HiRes qw(gettimeofday);
use PiConstants qw($TUTBY_ROLE_ID $ASSESSOR_ROLE_ID);

use base qw(QBit::Application);

our $APPLICATION;

__PACKAGE__->set_accessors(
    'Application::Model::API::Yandex::AdFox'               => {'accessor' => 'api_adfox',},
    'Application::Model::API::Yandex::AdFoxGraphQL'        => {'accessor' => 'api_adfox_graphql',},
    'Application::Model::API::Yandex::AdFoxRTD'            => {'accessor' => 'api_adfox_rtd',},
    'Application::Model::API::Yandex::BK'                  => {'accessor' => 'api_bk',},
    'Application::Model::API::Yandex::Balalayka'           => {'accessor' => 'api_balalayka',},
    'Application::Model::API::Yandex::Balance'             => {'accessor' => 'api_balance',},
    'Application::Model::API::Yandex::BannerStorage::HTTP' => {'accessor' => 'api_http_banner_storage',},
    'Application::Model::API::Yandex::FormatSystem'        => {'accessor' => 'api_format_system',},
    'Application::Model::API::Yandex::HBF'                 => {'accessor' => 'api_hbf',},
    'Application::Model::API::Yandex::HTTPMOL'             => {'accessor' => 'api_http_mol',},
    'Application::Model::API::Yandex::Maps'                => {'accessor' => 'api_http_maps',},
    'Application::Model::API::Yandex::MediaStorage'        => {'accessor' => 'api_media_storage',},
    'Application::Model::API::Yandex::MediaStorage::S3'    => {'accessor' => 'api_media_storage_s3',},
    'Application::Model::API::Yandex::News'                => {'accessor' => 'api_http_news',},
    'Application::Model::API::Yandex::OEBS'                => {'accessor' => 'api_oebs',},
    'Application::Model::API::Yandex::SelfService'         => {'accessor' => 'api_selfservice',},
    'Application::Model::API::Yandex::Sender'              => {'accessor' => 'api_sender',},
    'Application::Model::API::Yandex::Staff'               => {'accessor' => 'api_staff',},
    'Application::Model::API::Yandex::TVM'                 => {'accessor' => 'api_tvm',},
    'Application::Model::API::Yandex::UtilsPartner2'       => {'accessor' => 'api_utils_partner2',},
    'Application::Model::API::Yandex::YaMoney'             => {'accessor' => 'api_yamoney',},
    'Application::Model::API::Yandex::SelfemployedOeBS'    => {'accessor' => 'api_selfemployed_oebs'},
    'Application::Model::API::Yandex::MoneyMap'            => {'accessor' => 'api_moneymap'},
    'Application::Model::API::Yandex::RMP'                 => {'accessor' => 'api_rmp'},
    'Application::Model::API::Yandex::JavaBKData'          => {'accessor' => 'api_java_bk_data'},
    'Application::Model::AgreementChecker'                 => {'accessor' => 'agreement_checker',},
    'Application::Model::AllPages'                         => {'accessor' => 'all_pages',},
    'Application::Model::Assistants'                       => {'accessor' => 'assistants',},
    'Application::Model::AutoStart'                        => {'accessor' => 'auto_start',},
    'Application::Model::AutoStop'                         => {'accessor' => 'auto_stop',},
    'Application::Model::Banks'                            => {'accessor' => 'banks',},
    'Application::Model::BanksDB'                          => {'accessor' => 'banks_db',},
    'Application::Model::BannedCountries'                  => {'accessor' => 'banned_countries',},
    'Application::Model::BKLanguage'                       => {'accessor' => 'bk_language',},
    'Application::Model::BkPiComparison'                   => {'accessor' => 'devel_bk_pi_comparison',},
    'Application::Model::BKStatistics'                     => {'accessor' => 'bk_statistics',},
    'Application::Model::Block::Content::FastBan'          => {'accessor' => 'fast_ban',},
    'Application::Model::BlockPresets'                     => {
        'accessor'       => 'block_presets',
        'has_action_log' => TRUE,
    },
    'Application::Model::BlockTags' => {
        'accessor'       => 'block_tags',
        'has_action_log' => TRUE,
    },
    'Application::Model::BusinessRules'  => {'accessor' => 'business_rules', 'has_action_log' => TRUE},
    'Application::Model::BusinessBlocks' => {'accessor' => 'business_blocks'},
    'Application::Model::ClickhouseDB'   => {'accessor' => 'clickhouse_db',},
    'Application::Model::Contracts'      => {'accessor' => 'contracts',},
    'Application::Model::CookieMatch'    => {
        'accessor'       => 'cookie_match',
        'has_action_log' => TRUE,
    },
    'Application::Model::CookieMatch::LinkPi' => {'accessor' => 'cookie_match_link_pi',},
    'Application::Model::CookieMatch::Owners' => {'accessor' => 'cookie_match_owners',},
    'Application::Model::Crimea'              => {'accessor' => 'crimea',},
    'Application::Model::Currency'            => {'accessor' => 'currency',},
    'Application::Model::CurUser'             => {'accessor' => 'cur_user',},
    'Application::Model::CustomBKOptions'     => {'accessor' => 'custom_bk_options',},
    'Application::Model::DBDumper'            => {'accessor' => 'db_dumper',},
    'Application::Model::DesignTemplates'     => {'accessor' => 'design_templates', 'has_action_log' => TRUE},
    'Application::Model::Product::AN::Distribution' => {
        'accessor'       => 'distribution_campaign',
        'has_action_log' => TRUE,
        'tags'           => ['source_model', 'page_model']
    },
    'Application::Model::Documents' => {'accessor' => 'documents',},
    'Application::Model::DSP'       => {
        'accessor'       => 'dsp',
        'has_action_log' => TRUE,
    },
    'Application::Model::DSP::Documentation' => {
        'accessor'       => 'dsp_documentation',
        'has_action_log' => TRUE,
    },
    'Application::Model::DSP::StatisticsResponse' => {'accessor' => 'statistics_dsp_response',},
    'Application::Model::DSP::Testing'            => {'accessor' => 'dsp_testing',},
    'Application::Model::ErrorBooster'            => {'accessor' => 'errorbooster',},
    'Application::Model::ExceptionDumper'         => {'accessor' => 'exception_dumper',},
    'Application::Model::Sentry'                  => {'accessor' => 'sentry',},
    'Application::Model::Excluded::Domains'       => {'accessor' => 'excluded_domains',},
    'Application::Model::Excluded::Phones'        => {'accessor' => 'excluded_phones',},
    'Application::Model::Filters'                 => {'accessor' => 'filters',},
    'Application::Model::Frontend'                => {'accessor' => 'frontend',},
    'Application::Model::GeoBase'                 => {'accessor' => 'geo_base',},
    'Application::Model::IntAPI_ACL'              => {'accessor' => 'intapi_acl',},
    'Application::Model::InternalSite'            => {'accessor' => 'internal_site', 'tags' => ['source_model']},
    'Application::Model::Inviter'                 => {'accessor' => 'inviter',},
    'Application::Model::Kladr'                   => {'accessor' => 'kladr',},
    'Application::Model::Log::BkEditPage'         => {'accessor' => 'bk_edit_page',},
    'Application::Model::Log::ModelsSoapApi'      => {'accessor' => 'models_soap_api',},
    'Application::Model::MailNotification'        => {'accessor' => 'mail_notification',},
    'Application::Model::Managers'                => {'accessor' => 'managers',},
    'Application::Model::MDSAvatars'              => {'accessor' => 'mds_avatars',},
    'Application::Model::Moderation' => {
        'accessor'       => 'moderation',
        'has_action_log' => 'moderation_queue_action_log',
    },
    'Application::Model::Moderation::BadDomains' => {'accessor' => 'moderation_bad_domains',},
    'Application::Model::MultiModel::Blocks'     => {'accessor' => 'blocks',},
    'Application::Model::MultiModel::Pages'      => {'accessor' => 'pages',},
    'Application::Model::MultiModel::AllPages'   => {'accessor' => 'multimodel_all_pages',},
    'Application::Model::News'                   => {'accessor' => 'news',},
    'Application::Model::PageOptions'            => {'accessor' => 'page_options',},
    'Application::Model::PagesBS'                => {'accessor' => 'pagesbs',},
    'Application::Model::Page::Video'            => {
        'accessor'       => 'video_an_site',
        'tags'           => ['page_model', 'external', 'source_model', 'video_model', 'has_bk_stat'],
        'has_action_log' => TRUE,
        'models'         => {
            'categories' => 'video_an_site_categories',
            'mirrors'    => 'video_an_site_mirrors',
        },
    },
    'Application::Model::Page::InDoor' => {
        'accessor'       => 'indoor',
        'tags'           => ['source_model', 'page_model', 'external'],
        'has_action_log' => TRUE
    },
    'Application::Model::Block::InDoor' => {
        'accessor'       => 'indoor_block',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'indoor'},
    },
    'Application::Model::Page::OutDoor' => {
        'accessor'       => 'outdoor',
        'tags'           => ['source_model', 'page_model', 'external'],
        'has_action_log' => TRUE
    },
    'Application::Model::Block::OutDoor' => {
        'accessor'       => 'outdoor_block',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'outdoor'},
    },
    'Application::Model::Monetizers'                          => {'accessor' => 'monetizers',},
    'Application::Model::PartnerActs'                         => {'accessor' => 'partner_acts',},
    'Application::Model::PartnerDB'                           => {'accessor' => 'partner_db',},
    'Application::Model::PartnerDocuments'                    => {'accessor' => 'partner_documents',},
    'Application::Model::PartnerLogsDB'                       => {'accessor' => 'partner_logs_db',},
    'Application::Model::PartnerMonitoring'                   => {'accessor' => 'partner_monitoring',},
    'Application::Model::Block::DSPs'                         => {'accessor' => 'block_dsps',},
    'Application::Model::Block::DSPsUnmoderated'              => {'accessor' => 'block_dsps_unmoderated',},
    'Application::Model::Product::AN::ContextOnSite::AdBlock' => {
        'accessor'       => 'context_on_site_adblock',
        'tags'           => ['rtb_model', 'block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::Campaign' => {
        'accessor'       => 'context_on_site_campaign',
        'tags'           => ['site_model', 'page_model', 'external', 'has_bk_stat'],
        'has_action_log' => TRUE,
        'models' => {'mirrors' => 'context_on_site_mirrors',},
    },
    'Application::Model::Product::AN::ContextOnSite::Campaign::Mirrors' => {'accessor' => 'context_on_site_mirrors',},
    'Application::Model::Product::AN::ContextOnSite::Campaign::YaCategories' =>
      {'accessor' => 'context_on_site_ya_categories',},
    'Application::Model::Product::AN::ContextOnSite::Direct' => {
        'accessor'       => 'context_on_site_direct',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::Market' => {
        'accessor'       => 'context_on_site_market',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::MarketAPI' => {
        'accessor'       => 'context_on_site_market_api',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::MCB' => {
        'accessor'       => 'context_on_site_mcb',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::RTB' => {
        'accessor'       => 'context_on_site_rtb',
        'tags'           => ['block_model', 'rtb_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::Content' => {
        'accessor'       => 'context_on_site_content',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'context_on_site_campaign'}
    },
    'Application::Model::Product::AN::ContextOnSite::Stripe' => {
        'accessor'       => 'context_on_site_stripe',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'context_on_site_campaign',},
    },
    'Application::Model::Product::AN::ContextOnSite::Natural' => {
        'accessor'       => 'context_on_site_natural',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'context_on_site_campaign'}
    },
    'Application::Model::Product::AN::MobileApp' => {
        'accessor'       => 'mobile_app',
        'tags'           => ['source_model'],
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::AN::MobileApp::MobileAppOwner' => {'accessor' => 'mobile_app_owner',},
    'Application::Model::Product::AN::MobileApp::RTB'            => {
        'accessor'       => 'mobile_app_rtb',
        'tags'           => ['block_model', 'rtb_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'mobile_app_settings',},
    },
    'Application::Model::Product::AN::MobileApp::Settings' => {
        'accessor'       => 'mobile_app_settings',
        'tags'           => ['page_model', 'external', 'has_bk_stat'],
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::AN::SearchOnSite::Campaign' => {
        'accessor'       => 'search_on_site_campaign',
        'tags'           => ['site_model', 'page_model', 'external', 'has_bk_stat'],
        'has_action_log' => TRUE,
        'models' => {'mirrors' => 'search_on_site_mirrors',},
    },
    'Application::Model::Product::AN::SearchOnSite::Campaign::Mirrors' => {'accessor' => 'search_on_site_mirrors',},
    'Application::Model::Product::AN::SearchOnSite::Direct'            => {
        'accessor'       => 'search_on_site_direct',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'search_on_site_campaign',},
    },
    'Application::Model::Product::AN::SearchOnSite::Market' => {
        'accessor'       => 'search_on_site_market',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'search_on_site_campaign',},
    },
    'Application::Model::Product::AN::SearchOnSite::MarketAPI' => {
        'accessor'       => 'search_on_site_market_api',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'search_on_site_campaign',},
    },
    'Application::Model::Product::AN::SearchOnSite::MCB' => {
        'accessor'       => 'search_on_site_mcb',
        'tags'           => ['block_model', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'search_on_site_campaign',},
    },
    'Application::Model::Product::AN::SearchOnSite::Premium' => {
        'accessor'       => 'search_on_site_premium',
        'tags'           => ['block_model', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'search_on_site_campaign',},
    },
    'Application::Model::Product::AN::Site' => {
        'accessor'       => 'site',
        'tags'           => ['source_model'],
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::AN::Site::OwnerSite'                         => {'accessor' => 'owner_site',},
    'Application::Model::Product::Articles'                                    => {'accessor' => 'articles',},
    'Application::Model::Product::Brands'                                      => {'accessor' => 'brands',},
    'Application::Model::Product::PICategories'                                => {'accessor' => 'picategories',},
    'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign' => {
        'accessor'       => 'internal_context_on_site_campaign',
        'tags'           => ['internal', 'site_model', 'page_model', 'has_bk_stat'],
        'has_action_log' => TRUE,
        'models'         => {
            'mirrors' => 'internal_context_on_site_mirrors',
            'site'    => 'internal_site',
        },
    },
    'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign::Mirrors' =>
      {'accessor' => 'internal_context_on_site_mirrors',},
    'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign::YaCategories' =>
      {'accessor' => 'internal_context_on_site_ya_categories',},
    'Application::Model::Product::InternalAN::InternalContextOnSite::Direct' => {
        'accessor'       => 'internal_context_on_site_direct',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_context_on_site_campaign',},
    },
    'Application::Model::Product::InternalAN::InternalContextOnSite::RTB' => {
        'accessor'       => 'internal_context_on_site_rtb',
        'tags'           => ['block_model', 'rtb_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_context_on_site_campaign',},
    },
    'Application::Model::Product::InternalAN::InternalContextOnSite::Stripe' => {
        'accessor'       => 'internal_context_on_site_stripe',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_context_on_site_campaign',},
    },
    'Application::Model::Product::InternalAN::InternalContextOnSite::Content' => {
        'accessor'       => 'internal_context_on_site_content',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_context_on_site_campaign'}
    },
    'Application::Model::Product::InternalAN::InternalContextOnSite::Natural' => {
        'accessor'       => 'internal_context_on_site_natural',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_context_on_site_campaign'}
    },
    'Application::Model::Product::InternalAN::InternalSearchOnSite::Campaign' => {
        'accessor'       => 'internal_search_on_site_campaign',
        'tags'           => ['internal', 'site_model', 'page_model', 'has_bk_stat'],
        'has_action_log' => TRUE,
        'models'         => {
            'mirrors' => 'internal_search_on_site_mirrors',
            'site'    => 'internal_site',
        },
    },
    'Application::Model::Product::InternalAN::InternalSearchOnSite::Campaign::Mirrors' =>
      {'accessor' => 'internal_search_on_site_mirrors',},
    'Application::Model::Product::InternalAN::InternalSearchOnSite::Direct' => {
        'accessor'       => 'internal_search_on_site_direct',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_search_on_site_campaign',},
    },
    'Application::Model::Product::InternalAN::InternalSearchOnSite::Premium' => {
        'accessor'       => 'internal_search_on_site_premium',
        'tags'           => ['block_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_search_on_site_campaign',},
    },
    'Application::Model::Product::InternalAN::MobileApp' => {
        'accessor'       => 'internal_mobile_app',
        'tags'           => ['source_model', 'internal', 'page_model', 'has_bk_stat'],
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::InternalAN::MobileApp::RTB' => {
        'accessor'       => 'internal_mobile_app_rtb',
        'tags'           => ['block_model', 'rtb_model'],
        'has_action_log' => TRUE,
        'models'         => {'page' => 'internal_mobile_app',},
    },
    'Application::Model::ProductManager'                     => {'accessor' => 'product_manager',},
    'Application::Model::Product::VideoAN::Site::Categories' => {'accessor' => 'video_an_site_categories',},
    'Application::Model::Product::VideoAN::Site::Fullscreen' => {
        'accessor'       => 'video_an_site_fullscreen',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'video_an_site'},
    },
    'Application::Model::Product::VideoAN::Site::InPage' => {
        'accessor'       => 'video_an_site_inpage',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'video_an_site'},
    },
    'Application::Model::Product::VideoAN::Site::InStream' => {
        'accessor'       => 'video_an_site_instream',
        'tags'           => ['block_model', 'can_auto_start', 'can_auto_stop'],
        'has_action_log' => TRUE,
        'models' => {'page' => 'video_an_site'},
    },
    'Application::Model::VideoScenaries' => {'accessor' => 'video_scenaries', 'has_action_log' => TRUE,},
    'Application::Model::Product::VideoAN::Site::Video::Blockings'       => {'accessor' => 'video_an_site_blockings',},
    'Application::Model::Product::VideoAN::Site::Video::InternalContent' => {
        'accessor'       => 'internal_content',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::VideoAN::Site::Video::InternalContent::ContentBrand' =>
      {'accessor' => 'content_brand',},
    'Application::Model::Product::VideoAN::Site::Video::InternalContent::ContentType' =>
      {'accessor' => 'content_type',},
    'Application::Model::Product::VideoAN::Site::Video::InternalContent::DictionaryWords' =>
      {'accessor' => 'dictionary_words',},
    'Application::Model::Product::VideoAN::Site::Video::InternalContent::InternalContentGenres' =>
      {'accessor' => 'internal_content_genres',},
    'Application::Model::Product::VideoAN::Site::Video::InternalGenre' => {
        'accessor'       => 'internal_genre',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::VideoAN::Site::Video::Mirrors' => {'accessor' => 'video_an_site_mirrors',},
    'Application::Model::Product::VideoAN::Site::Video::PartnerAndInternalGenre' =>
      {'accessor' => 'partner_and_internal_genre',},
    'Application::Model::Product::VideoAN::Site::Video::PartnerContent' => {
        'accessor'       => 'partner_content',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::VideoAN::Site::Video::PartnerContent::PartnerContentGenres' =>
      {'accessor' => 'partner_content_genres',},
    'Application::Model::Product::VideoAN::Site::Video::PartnerGenre' => {
        'accessor'       => 'partner_genre',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::VideoAN::Site::Video::StatFiles' => {'accessor' => 'video_stat_files',},
    'Application::Model::QBitValidatorChecker'                     => {'accessor' => 'qbit_validator_checker',},
    'Application::Model::QualityCoef'                              => {'accessor' => 'quality_coef',},
    'Application::Model::Queue'                                    => {'accessor' => 'queue',},
    'Application::Model::Queue::Methods'                           => {'accessor' => 'queue_methods',},
    'Application::Model::RBAC'                                     => {
        'accessor' => 'rbac',
        'models'   => {'db' => 'partner_db',},
    },
    'Application::Model::Requisites'         => {'accessor' => 'requisites',},
    'Application::Model::BkData'             => {'accessor' => 'bkdata',},
    'Application::Model::Resources'          => {'accessor' => 'resources',},
    'Application::Model::SendMail'           => {'accessor' => 'mailer',},
    'Application::Model::ShortLink'          => {'accessor' => 'short_link',},
    'Application::Model::SimpleNotification' => {
        'accessor'       => 'simple_notification',
        'has_action_log' => TRUE,
    },
    'Application::Model::Notification' => {
        'accessor'       => 'notification',
        'has_action_log' => TRUE,
    },
    'Application::Model::ModerationReason' => {
        'accessor'       => 'moderation_reason',
        'has_action_log' => TRUE,
    },
    'Application::Model::UserNotifications'    => {'accessor' => 'user_notifications',},
    'Application::Model::StatDownloadData'     => {'accessor' => 'stat_download_data',},
    'Application::Model::Statistics'           => {'accessor' => 'statistics',},
    'Application::Model::Statistics::Charging' => {'accessor' => 'statistics_charging', 'tags' => ['statistics'],},
    'Application::Model::Statistics::Charging::DSP' =>
      {'accessor' => 'statistics_dsp', 'tags' => ['statistics', 'statistics_products'],},
    'Application::Model::Statistics::AdditionalIncome' =>
      {'accessor' => 'statistics_additional_income', 'tags' => ['statistics'],},
    'Application::Model::Statistics::ReportParamsDigest' => {'accessor' => 'stat_report_params_digest',},
    'Application::Model::StatisticsReports'              => {
        'accessor'       => 'statistics_reports',
        'has_action_log' => TRUE,
    },
    'Application::Model::SystemEvents' => {'accessor' => 'system_events'},
    'Application::Model::TextTemplate' => {
        'accessor'       => 'text_template',
        'has_action_log' => TRUE,
    },
    'Application::Model::ThematicFilters'  => {'accessor' => 'thematic_filters',},
    'Application::Model::TNSDict::Article' => {'accessor' => 'tns_dict_article',},
    'Application::Model::TNSDict::Brand'   => {'accessor' => 'tns_dict_brand',},
    'Application::Model::PICategoriesDict' => {'accessor' => 'picategories_dict',},
    'Application::Model::Users'            => {
        'accessor'       => 'users',
        'has_action_log' => TRUE,
    },
    'Application::Model::Users::GlobalExcludedDomains' => {'accessor' => 'user_global_excluded_domains',},
    'Application::Model::Users::GlobalExcludedPhones'  => {'accessor' => 'user_global_excluded_phones',},
    'Application::Model::Users::Features'              => {'accessor' => 'user_features',},
    'Application::Model::Validator'                    => {'accessor' => 'validator',},
    'Application::Model::VIP_Partners'                 => {'accessor' => 'vip_partners',},
    'Application::Model::Widgets'                      => {
        'accessor'       => 'widgets',
        'has_action_log' => TRUE,
    },
    'Application::Model::Widgets::Widget::PaymentDisclaimer' =>
      {'accessor' => 'widget_payment_disclaimer', tags => ['widgets'],},
    'Application::Model::Widgets::Widget::DspErrors' => {'accessor' => 'widget_dsp_errors', tags => ['widgets'],},
    'Application::Model::Widgets::Widget::ProductsSearch' =>
      {'accessor' => 'widget_product_search', tags => ['widgets'],},
    'Application::Model::Widgets::Widget::Revenue'       => {'accessor' => 'widget_revenue',    tags => ['widgets'],},
    'Application::Model::Widgets::Widget::Statistics'    => {'accessor' => 'widget_statistics', tags => ['widgets'],},
    'Application::Model::Widgets::Widget::Summary'       => {'accessor' => 'widget_summary',    tags => ['widgets'],},
    'Application::Model::Widgets::Widget::Welcome'       => {'accessor' => 'widget_welcome',    tags => ['widgets'],},
    'Application::Model::Widgets::Widget::Adfox'         => {'accessor' => 'widget_adfox',      tags => ['widgets'],},
    'Application::Model::YaCategories'                   => {'accessor' => 'ya_categories',},
    'QBit::Application::Model::API::Yandex::BlackBox'    => {'accessor' => 'api_blackbox',},
    'QBit::Application::Model::API::Yandex::Cabinet'     => {'accessor' => 'api_cabinet',},
    'QBit::Application::Model::API::Yandex::ConvDB'      => {'accessor' => 'api_conv_db',},
    'QBit::Application::Model::API::Yandex::HTTPBK'      => {'accessor' => 'api_http_bk',},
    'QBit::Application::Model::API::Yandex::HTTPGeobase' => {'accessor' => 'api_geobase',},
    'QBit::Application::Model::API::Yandex::HTTPMAAS'    => {'accessor' => 'api_http_maas',},
    'QBit::Application::Model::API::Yandex::Metrika'     => {'accessor' => 'api_metrika',},
    'QBit::Application::Model::API::Yandex::Passport'    => {'accessor' => 'api_passport',},
    'QBit::Application::Model::API::Yandex::Solomon'     => {'accessor' => 'api_solomon',},
    'QBit::Application::Model::API::Yandex::StarTrek'    => {'accessor' => 'startrek',},
    'QBit::Application::Model::API::Yandex::YT'          => {'accessor' => 'api_yt',},
    'QBit::Application::Model::API::Yandex::YT::BK'      => {'accessor' => 'api_yt_bk',},
    'QBit::Application::Model::API::Yandex::YT::Partner' => {'accessor' => 'api_yt_partner',},
    'QBit::Application::Model::API::Yandex::YT::Partner::CategoryMapping' =>
      {'accessor' => 'api_yt_partner_picategory_mapping',},
    'QBit::Application::Model::API::Yandex::YQL'                     => {'accessor' => 'api_yql',},
    'QBit::Application::Model::API::Yandex::YT::Partner::TargetTags' => {'accessor' => 'api_yt_partner_target_tags',},
    'QBit::Application::Model::API::Yandex::HTTPGoZora'              => {'accessor' => 'api_http_gozora',},
    'QBit::Application::Model::API::Yandex::MediaStorageAvatars'     => {'accessor' => 'api_media_storage_avatars',},
    'QBit::Application::Model::KvStore'                              => {
        'accessor' => 'kv_store',
        'models'   => {'db' => 'partner_db',},
    },
    'QBit::Application::Model::Memcached'        => {'accessor' => 'memcached',},
    'QBit::Application::Model::YandexLangDetect' => {'accessor' => 'lang_detect',},
    'RestApi::SimpleModel::Errors'               => {'accessor' => 'errors',},

    'Application::Model::Product::SSP::Seller'        => {'accessor' => 'ssp_seller'},
    'Application::Model::Product::SSP::ImpressionLog' => {'accessor' => 'ssp_imps'},
    'Application::Model::Product::SSP::Site'          => {'accessor' => 'ssp_site', 'tags' => ['source_model']},
    'Application::Model::Product::SSP::Link::ContextRTB' => {
        'accessor'       => 'ssp_link_context_rtb',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::SSP::Link::MobileApp' => {
        'accessor'       => 'ssp_link_mobile_app',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::SSP::Link::VideoApp' => {
        'accessor'       => 'ssp_link_video_app',
        'has_action_log' => TRUE,
    },
    'Application::Model::Product::SSP::ContextOnSite::Campaign' => {
        'accessor' => 'ssp_context_on_site_campaign',
        'tags'     => ['page_model', 'has_bk_stat'],
        'models'   => {
            'ssp_source'  => 'ssp_site',
            'ssp_links'   => 'ssp_link_context_rtb',
            'ssp_mirrors' => 'ssp_context_on_site_campaign_mirrors',
        },
    },
    'Application::Model::Product::SSP::ContextOnSite::RTB' => {
        'accessor' => 'ssp_context_on_site_rtb',
        'tags'     => ['block_model', 'rtb_model'],
        'models'   => {'page' => 'ssp_context_on_site_campaign',}
    },
    'Application::Model::Product::SSP::ContextOnSite::Campaign::Mirrors' =>
      {'accessor' => 'ssp_context_on_site_campaign_mirrors'},
    'Application::Model::Product::SSP::Application' => {'accessor' => 'ssp_application', 'tags' => ['source_model']},
    'Application::Model::Product::SSP::MobileApp::Settings' => {
        'accessor' => 'ssp_mobile_app_settings',
        'tags'     => ['page_model', 'has_bk_stat'],
        'models'   => {
            'ssp_source'  => 'ssp_application',
            'ssp_links'   => 'ssp_link_mobile_app',
            'ssp_mirrors' => 'ssp_mobile_app_settings_mirrors',
        }
    },
    'Application::Model::Product::SSP::MobileApp::RTB' => {
        'accessor' => 'ssp_mobile_app_rtb',
        'tags'     => ['block_model', 'rtb_model'],
        'models'   => {'page' => 'ssp_mobile_app_settings',}
    },
    'Application::Model::Product::SSP::MobileApp::Settings::Mirrors' =>
      {'accessor' => 'ssp_mobile_app_settings_mirrors'},
    'Application::Model::Product::SSP::VideoAN::Site' => {
        'accessor' => 'ssp_video_an_site',
        'tags'     => ['page_model'],
        'models'   => {
            'ssp_source'  => 'ssp_application',
            'ssp_links'   => 'ssp_link_video_app',
            'ssp_mirrors' => 'ssp_video_an_site_mirrors',
        }
    },
    'Application::Model::Product::SSP::VideoAN::Site::RTB' => {
        'accessor' => 'ssp_video_an_site_rtb',
        'tags'     => ['block_model', 'rtb_model'],
        'models'   => {'page' => 'ssp_video_an_site',}
    },
    'Application::Model::Product::SSP::VideoAN::Site::Mirrors' => {'accessor' => 'ssp_video_an_site_mirrors',},
    'Application::Model::CommonOffer'                          => {'accessor' => 'common_offer'},
    'Application::Model::Queue::Support'                       => {'accessor' => 'support'},
    'Application::Model::CheckAlive'                           => {'accessor' => 'check_alive'},
    'Application::Model::API::Yandex::JavaJsonApi'             => {'accessor' => 'api_java_jsonapi'},
);

use Exception;
use Exception::BlackBox;
use Exception::Validation::BadArguments;

=head2 add_all_tmp_rights

    my $tmp_rights = $self->app->add_all_tmp_rights();

Есть все права до тех пор, пока $tmp_rights не вышел из скоупа.

=cut

sub add_all_tmp_rights {
    my ($self) = @_;
    my @all_rights = grep {$_ ne 'edit_protected_pages'} keys(%{$self->get_registered_rights()});
    return $self->add_tmp_rights(@all_rights);
}

sub get_contract_model {
    my ($self, $type) = @_;

    my $contract_model;
    if ($type eq 'yan') {
        $contract_model = $self->contract_yan;
    } elsif ($type eq 'test') {
        $contract_model = $self->contract_test;
    } else {
        throw Exception::Validation::BadArguments gettext("Unknown type");
    }

    return $contract_model;
}

sub get_locales {
    my ($self) = @_;

    my $locales = $self->get_option('locales');

    throw Exception gettest('Uknown locales') unless defined $locales;

    return $locales;

}

sub get_url_origin {
    my ($self, %opts) = @_;

    my $stage = $self->get_option('stage', 'unknown');
    my $url;

    if ($stage eq 'production') {
        $url = 'https://partner2.yandex.ru';
    } elsif ($stage eq 'preprod') {
        $url = 'https://partner2-preprod.yandex.ru';
    } elsif ($stage eq 'test') {
        $url = 'https://partner2-test.yandex.ru';
    } elsif ($stage eq 'autotest') {
        $url = 'https://partner2-balancer-autotest.partner.yandex.ru';
    } elsif ($stage eq 'dev') {
        #In case of testing there is no beta launched
        #so $url is just filled with dummy value
        if ($ENV{TAP_VERSION} // $ENV{RESTAPI_VERSION}) {
            $url = 'https://hostname:1234';
        } else {
            my $host = $ENV{PARTNER2_HOST} // $self->get_option('hostname');
            my $port = $ENV{PARTNER2_HTTPS_PORT} // ((cwd =~ m{\.(\d+)})[0] + 400);
            $url = "https://$host:$port";
        }
    } else {
        throw Exception "Unknown stage name: $stage";
    }

    $opts{'lang'} //= 'ru';
    my $domain = $self->get_option('locales', {})->{$opts{'lang'}}{'domain'};
    $url =~ s/yandex\.[^:]+(\:\d+)?$/$domain . ($1 || '')/e if defined($domain);

    return $url;
}

=head2 get_user_lang

B<Параметры:> $uid

B<Возвращаемое значение:> $lang - двухбуквенный символ языка пользователя,
например 'ru' или 'en'.

Всегда возащает корректный язык, который есть в системе. Если не получили язык
из паспорта или этот язык не поддерживается на проекте, то будет возвращен
дефолтный язык 'ru'.

=cut

sub get_user_lang {
    my ($self, $uid) = @_;

    my $return;

    try {
        my $bb_info = $self->api_blackbox->userinfo(
            uid    => $uid,
            fields => [qw(userinfo.lang.uid)],
        );

        my $user_lang = $bb_info->{dbfield}->{'userinfo.lang.uid'} // 'ru';

        $return = $user_lang if in_array($user_lang, [keys(%{$self->get_option('locales', {})})]);
    }
    catch Exception::BlackBox;

    return $return || 'ru';
}

sub init {
    my ($self) = @_;

    $self->use_config('Application.json');
    $self->use_db_config();

    $self->SUPER::init();

    Utils::MonitoringUtils::set_application($self);
    Utils::Logger::set_app($self);
    $APPLICATION = $self;

    return 1;
}

sub init_accessors {
    my ($self) = @_;

    $self->SUPER::init_accessors();

}

sub set_time {
    my ($self) = @_;
    $self->set_option("time_of_process" => gettimeofday());
}

sub get_time {
    my ($self) = @_;
    return sprintf '%.2f', gettimeofday() - $self->get_option("time_of_process", 0);
}

sub pre_run {
    my ($self) = @_;
    $self->SUPER::pre_run();
    $self->set_time();
    return $self;
}

sub use_db_config {
    my ($self) = @_;

    $self->_push_pkg_opts(name => get_db_settings());

    return 1;
}

sub set_cur_user {
    my ($self, $user) = @_;

    $self->revoke_cur_user_rights($self->{'__OPTIONS__'}{'cur_user'}{'rights'} // []);

    $self->set_option('cur_user', $user);

    if ($user) {
        $ENV{'LOGIN'} = $user->{'login'} // '';

        my $user_adfox = $self->partner_db->user_adfox->get_all(
            fields => ['adfox_id'],
            filter => $self->partner_db->filter({user_id => $user->{'id'}}),
            limit  => 1,
        );

        $user->{'has_adfox'} = (@$user_adfox && $user_adfox->[0]->{'adfox_id'}) ? 1 : 0;

        my ($roles, $rights) = $self->users->get_roles_and_rights($user->{'id'});
        $user->{'roles'}  = $roles;
        $user->{'rights'} = $rights;

        $self->set_cur_user_rights($user->{'rights'});

        $user->{'can_view_adfox_fields'} = $user->{'has_adfox'}
          || grep {$user->{'roles'}{$_}{'is_internal'}} keys %$roles;

        $user->{'is_tutby_aggregator'} = exists $roles->{$TUTBY_ROLE_ID};
    }
}

TRUE;
