package Application::Model::API::SOAPLogger;

use qbit;
use Data::Rmap;
use Compress::Zlib;

use base qw(QBit::Application::Model Application::Model::API::HTTPLogger);

__PACKAGE__->model_accessors(partner_logs_db => 'Application::Model::PartnerLogsDB',);

sub log {
    my ($self, $data) = @_;

    $data->{'uri'} = '' if $self->isa('QBit::Application::Model::API::XMLRPC');
    $data->{'error'} = '' unless $data->{'error'};

    # При работе с балансом по XMLRPC мы иногда передаем объекты SOAP::Data
    # В логировании преобразоываем этот объект в скалаяр для того чтобы можно
    # было серелизовать структуру в json
    rmap_all {$_ = $_->value if ref($_) eq 'SOAP::Data'} $data->{'params'};

    $self->SUPER::log($data);
}

TRUE;
