
=encoding UTF-8
=cut

=head1 Описание

L<Документация|http://wiki.yandex-team.ru/Testirovanie/FuncTesting/AdvTechnologies/BK/piTest>.

=cut

package Application::Model::API::Yandex::BK;

use qbit;
use base qw(QBit::Application::Model::API::SOAP Application::Model::API::SOAPLogger);
use CHI;
use Data::Rmap;
use Compress::Zlib;
use Utils::Logger qw(INFOF);
use Utils::MonitoringUtils qw(send_to_graphite);

use Time::HiRes qw(gettimeofday tv_interval);
use PiConstants
  qw($ADINSIDE_CLIENT_ID $PAGE_KEYS_TRANSFORM :PAGE_SLOT $TRANSPORTS_KVSTORE_KEYS $PROTOBUF_JAVA_TRANSPORT_TURN_ON_KEY );

use Exception::BK;
use Exception::BK::EditPage;
use Exception::BK::BadArgument;
use Exception::BK::Protected;

__PACKAGE__->model_accessors(
    api_selfservice    => 'Application::Model::API::Yandex::SelfService',
    api_utils_partner2 => 'Application::Model::API::Yandex::UtilsPartner2',
    kv_store           => 'QBit::Application::Model::KvStore',
    api_java_bk_data   => 'Application::Model::API::Yandex::JavaBKData',
);

sub accessor     {'api_bk'}
sub need_log_all {FALSE}

our $CHI_CACHE;

my %wide_formats = (
    '240x400'          => 1,
    '320x480'          => 1,
    '300x600'          => 1,
    '300x500'          => 1,
    '200x300'          => 1,
    '728x90'           => 1,
    '320x50'           => 1,
    '320x100'          => 1,
    '970x250'          => 1,
    'posterVertical'   => 1,
    'posterHorizontal' => 1,
    'extensibleMobile' => 1,
    'horizontal'       => 1,
    'newVk'            => 1,
);

=head1 Методы

=head2 create_or_update_campaign

B<Параметры:>

=over

=item B<$data> - указатель на хеш с информацией о площадке:

=over

=item B<page_id> - число, если не указано, то заводится новая площадка.

=item B<client_id> - число, ID партнёра в билинге.

=item B<name> - строка, название площадки.

=item B<places> - хеш, ID и параметры продуктов ({542 => {}, 755 => '240x400'}).

=item B<state> - строка, статус площадки (test, work, stopped).

=item B<description> - строка, описание площадки.

=item B<domain> - строка, домен площадки.

=item B<mirrors> - массив строк, зеркала площадки.

=item B<target_type> - число, тип площадки (2 - поисковая, 3 - контекстная, 8 - дистрибуция, 9 - форма поиска).

=item B<banners_count> - число, количество объявлений.

=item B<cpa> - число от 0 до 100, коэффициент качества.

=item B<options> - хеш, дополнительные параметры:

=over

=item B<distrdownloads> - 0|1, указывает, что площадка является "загрузками дистрибуции".

=item B<dontshowbehavior> - 0|1, не показывать поведенческий.

=item B<dontshowsex> - 0|1, семейный фильтр.

=item B<notaggr> - 0|1, ???.

=item B<BlockNew> - 0|1, убрать ссылку "Стать парнёром".

=item B<BlockAll> - 0|1, убрать ссылку "Все объявления".

=item B<BlockTitle> - строка, название над блоком.

=back

=item B<disabled_flags> - массив строк, не показывать банеры с этими флагами.

=item B<excluded_domains> - массив строк, не показывать рекламодателей с доменами или телефонами из этого списка
(телефоны должны быть в формате 0123456789.phone).

=item B<target_categories> - массив чисел, ID категорий 2-го уровня, по которым показывать рекламу.

=back

=back

B<Возвращаемое значение: >Page ID площадки

Метод умирает в случае каких-либо ошибок.

=cut

sub create_or_update_campaign {
    my ($self, $campaign, @opts) = @_;

    if (ref($campaign) eq 'ARRAY') {
        throw Exception::BK::BadArgument gettext("Method create_or_update_campaign can work only with one campaign");
    }

    if ($ENV{'SKIP_SEND_TO_BK'}) {
        INFOF("Skipped sending page_id=%s", $campaign->{'page_id'} // 'undef');
        return 1;
    }

    my %bk_data = $self->_get_bk_data([$campaign], @opts);
    my @bk_data = values %bk_data;

    my $accessor = $bk_data[0]{ProductID};

    $self->app->validator->check(
        data     => $bk_data[0],
        app      => $self->app->$accessor,
        template => {type => 'page_bk_data',},
        throw    => TRUE,
    );

    my ($is_send_to_bssoap, $is_send_to_logbroker, $is_send_protobuf) =
      $self->get_transports_to_send($accessor, $campaign->{'page_id'}, \@opts);

    if ($is_send_to_logbroker) {
        $self->_send_to_logbroker($bk_data[0]);
    }

    if ($is_send_protobuf) {
        $self->_send_to_java_protobuf_logbroker($bk_data[0]);
    }

    if ($is_send_to_bssoap) {
        $self->_send_to_bssoap(\%bk_data, @opts);
    }

    return $campaign->{'page_id'};
}

sub _send_to_bssoap {
    my ($self, $bk_data, @opts) = @_;

    my $t0 = [gettimeofday()];

    # Заменяем пустой хэш на объект
    rmap_all {
        my $self = shift;

        if (ref($_) eq 'HASH' && !%$_) {
            my $soap_hash_empty = SOAP::Data->type(SOAPStruct => {});
            # Уходит в рекурсию, если не пометить новый объект, как просмотренный
            rmap_all {$self->{'seen'}{refaddr($_) || ''} = undef;} $soap_hash_empty;
            $_ = $soap_hash_empty;
        }
    }
    $bk_data;

    my %bk_data = ();

    my $res_hs = $self->_set_page_id_if_need_and_call('EditPage', $bk_data, @opts);
    my $response = $res_hs->[0];

    my $elapsed = tv_interval($t0, [gettimeofday()]);

    my $page_id = $bk_data->{0}{'PageID'};
    my $addition = $page_id ? "Page ID: $page_id" : "creating new page";

    my $answer_json = eval {to_json($response)};
    INFOF('EditPage response time: %0.2f seconds for %s. %s', $elapsed, $addition, $answer_json);

    my $err_code = !$response->{'Error'} && $response->{'0'} ? $response->{'0'}->{'Error'} // '' : '';
    if ($err_code eq '0') {
        return $response->{'0'}->{'PageID'};
    } elsif ($err_code eq '100') {
        throw Exception::BK::Protected gettext(
            'The campaign with Page ID %s is closed for editing in BK. Ask your manager.', $page_id);
    } else {
        my $exception = Exception::BK::EditPage->new($self->{__SOAP__});
        my $msg       = $exception->message();
        $msg =~ s/\nData:.+//gs;
        $msg =~ s/\d+/X/g;
        $exception->{sentry}{fingerprint} = ['BK', 'Campaigns', $msg];
        throw $exception;
    }
}

sub set_conversion {
    my ($self, $data) = @_;

    my $res_hs = $self->call('SetConversion', $data);

    return;
}

sub _get_bk_data {
    my ($self, $campaigns, @opts) = @_;

    my %bk_data;
    my $i = 0;

    my $is_regular_update = scalar grep {ref $_ eq 'HASH' && $_->{is_regular_update}} @opts;

    foreach my $campaign (@$campaigns) {

        if (exists($campaign->{'state'})) {
            my %states = (
                work    => 1,
                test    => 0,
                stopped => -1,
                1       => 1,
                0       => 0,
                -1      => -1,
            );

            throw Exception::BK::BadArgument gettext("Parameter 'state' = '%s'", $campaign->{'state'})
              unless exists($states{$campaign->{'state'}});

            $campaign->{'state'} = $states{$campaign->{'state'}};
        }

        unless (exists($campaign->{'product_id'})) {
            throw Exception::BK::BadArgument gettext("Must specify product_id");
        }

        $campaign->{'rtb_video'}{'Contents'} = {}
          if exists($campaign->{'rtb_video'}) && !defined($campaign->{'rtb_video'}{'Contents'});

        # NOTE! в поле "patch" mirrors сразу задается в виде строки и тут ничего делать не нужно
        $campaign->{'mirrors'} = join(',', map {get_domain($_, ascii => 1, with_port => 1)} @{$campaign->{'mirrors'}})
          if exists($campaign->{'mirrors'}) && ref($campaign->{'mirrors'}) eq 'ARRAY';

        # NOTE! в поле "patch" Options сразу задается в виде строки и тут ничего делать не нужно
        if (exists($campaign->{'options'}) && ref($campaign->{'options'}) eq 'HASH') {
            $campaign->{'options'} = join(';',
                map    {"$_=$campaign->{'options'}{$_}"}
                  grep {$campaign->{'options'}{$_}}
                  qw(distrdownloads dontshowbehavior dontshowsex notaggr BlockNew BlockAll BlockTitle ReloadTimeout));
        }

        if (exists($campaign->{'disabled_flags'})) {
            my %extra_flags = (
                tobacco => [qw(tobacco_ex)],
                realtor => [qw(project_declaration)],
            );

            push(
                @{$campaign->{'disabled_flags'}},
                map {@{$extra_flags{$_}}} grep {$extra_flags{$_}} @{$campaign->{'disabled_flags'}}
            );

            $campaign->{'disabled_flags'} = join(',', @{$campaign->{'disabled_flags'}});
        }

        $campaign->{'excluded_domains'} = join(
            ',',
            (
                map {
                    get_bundle_id($_, 1) // get_bundle_id($_, 2) // get_domain($_, ascii => 1)
                      // throw Exception "Invalid excluded domain: $_"
                  } @{$campaign->{'excluded_domains'} // []}
            ),
            (
                map {
                    s/[^0-9]//g;
                    "$_.phone"
                  } @{clone($campaign->{'excluded_phones'} // [])}
            )
        ) if exists($campaign->{'excluded_domains'}) || exists($campaign->{'excluded_phones'});

        $campaign->{'target_categories'} = join(',', @{$campaign->{'target_categories'}})
          if exists($campaign->{'target_categories'});

        $campaign->{'is_yandex_page'} //= $campaign->{'client_id'} == $ADINSIDE_CLIENT_ID ? 1 : 0;

        if (exists($campaign->{rtb_blocks})) {
            foreach my $rtb_block (keys %{$campaign->{rtb_blocks}}) {
                if (  !defined($campaign->{rtb_blocks}->{$rtb_block}->{AllowedImageType})
                    && defined($campaign->{rtb_blocks}->{$rtb_block}->{RtbDesign}))
                {
                    my $rtb_design = $campaign->{rtb_blocks}->{$rtb_block}->{RtbDesign};
                    my $direct_block;
                    unless (ref $rtb_design) {
                        $direct_block = from_json("{$rtb_design}")->{name};
                    } elsif (%$rtb_design) {
                        my $any_key = (sort keys %$rtb_design)[0];
                        $direct_block = $rtb_design->{$any_key}->{design}->{name};
                    }

                    if ($direct_block && $wide_formats{$direct_block}) {
                        $campaign->{rtb_blocks}->{$rtb_block}->{AllowedImageType} = [qw(small regular wide)];
                    } else {
                        $campaign->{rtb_blocks}->{$rtb_block}->{AllowedImageType} = [qw(small regular)];
                    }
                }
            }
        }

        if ($campaign->{'domain'}) {
            # Педжи Дистрибуции (target_type=8) не проверяем на домен, так кок это совершенно не домены ("t.me/tovaritelega", "zen.yandex.ru/id/5d25243ecfcc8600ada5c9a9" и пр.)
            if (!defined $campaign->{target_type} || $campaign->{target_type} != 8) {
                $campaign->{'domain'} = $self->_get_source($campaign->{'domain'});
            }
        }

        my $unknown_keys_from_patch = {
            map {$_ => $campaign->{$_}}
              grep {!exists $PAGE_KEYS_TRANSFORM->{$_}}
              keys %$campaign
        };

        my $page_bk_data = {
            %$unknown_keys_from_patch,
            UpdateTimePI => curdate(oformat => 'db_time'),
            ($is_regular_update ? (IsRegularUpdate => 1) : ()),
            hash_transform($campaign, [], $PAGE_KEYS_TRANSFORM)
        };

        unless (defined $page_bk_data->{Slots}) {
            $page_bk_data->{Slots} = [];

            my $page_slots = {};
            $self->_update_page_slot($page_slots, $page_bk_data);
            if (%$page_slots) {
                $self->_update_page_slot_sequence($page_slots, $page_bk_data);
                $page_bk_data->{Slots} = [sort {$a->{SlotID} <=> $b->{SlotID}} values %$page_slots];
            }
        }

        $bk_data{$i++} = $page_bk_data;
    }

    return %bk_data;
}

# код перенесен из БК - https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-pi/Yabs/Transport/PI/Page.pm?rev=r7845498#L1639
sub _update_page_slot {
    my ($self, $page_slots, $page_bk_data) = @_;

    if (  !$page_bk_data->{ReadOnly}
        && $page_bk_data->{Places}
        && (!$page_bk_data->{OrigPageID} || $page_bk_data->{Name} =~ m/\.narod\.ru/))
    {

        while (my ($placeid, $slot) = each(%{$PAGE_SLOTS->{$page_bk_data->{TargetType}}})) {
            if (ref($slot) eq "HASH") {
                $slot = [$slot];
            }

            for my $slothash (@{$slot}) {
                my $slotid   = $slothash->{SlotID};
                my $total    = $slothash->{Total};
                my $typeid   = $slothash->{TypeID};
                my $slotdesc = $slothash->{Description};

                if (   $placeid == 542
                    && $page_bk_data->{PPCTotal} >= 3
                    && $page_bk_data->{PPCTotal} <= 9
                    && !defined($slothash->{_protect_total}))
                {
                    $total = $page_bk_data->{PPCTotal} + 2;
                }

                if (   !defined($page_bk_data->{Places}->{$placeid})
                    && $placeid != 706
                    && !$slothash->{"_protect_total"})
                {
                    $total = 0;
                }

                $page_slots->{$slotid} = {
                    SlotID      => $slotid,
                    Total       => $total,
                    TypeID      => $typeid,
                    Description => $slotdesc
                };
            }
        }
    }

    return $page_slots;
}

# код перенесен из БК - https://a.yandex-team.ru/arc/trunk/arcadia/yabs/interface/yabs-bssoap-pi/Yabs/Transport/PI/Page.pm?rev=r7845498#L1639
sub _update_page_slot_sequence {
    my ($self, $page_slots, $page_bk_data) = @_;

    if (  !$page_bk_data->{OrigPageID}
        || $page_bk_data->{Name} =~ m/\.narod\.ru/)
    {

        $page_bk_data->{Options} ||= '';
        $page_bk_data->{Places}  ||= {};

        my $page_options = {map {split /=/, $_} split(/;/, $page_bk_data->{Options})};

        my $media_size = "";
        foreach my $placeid (keys(%{$page_bk_data->{Places}})) {
            if (exists($PAGE_SLOTS->{$page_bk_data->{TargetType}}->{$placeid})
                && ref($page_bk_data->{Places}->{$placeid}) ne "HASH")
            {
                $media_size = $page_bk_data->{Places}->{$placeid} if ($PLACES_DESCRIPTION->{$placeid} eq 'media');
            }
        }

        my $dynamic = ($page_bk_data->{TargetType} == 3) ? 0 : 1;
        my $guaranteed = $page_bk_data->{PPCTotal} - $dynamic;
        my ($media_width, $media_height) = split('x', $media_size);
        while (my ($placegroup, $seqarr) = each(%{$PAGE_SLOT_SEQUENCES->{$page_bk_data->{TargetType}}})) {
            my $slottotal = 0;
            foreach my $seqhash (@{$seqarr}) {
                my $slotid    = $seqhash->{SlotID};
                my $seqid     = $seqhash->{SequenceID};
                my $plid      = int($seqhash->{PlaceID} || 0);
                my $select    = $seqhash->{PlaceSelect};
                my $limit     = $seqhash->{SequenceLimit};
                my $check     = $seqhash->{SequenceCheck};
                my $exception = int($seqhash->{ExceptionID} || 0);
                my $ordertype = $seqhash->{OrderType};
                my $seqtype   = $seqhash->{SequenceType} || '';
                my $printslot = $seqhash->{PrintSlotID};
                my $printseq  = $seqhash->{PrintSeqID};

                my $do_count = 1;

                if ($placegroup eq 'direct') {

                    if (!defined($seqhash->{_protect_sequencecheck})) {
                        $check = $slottotal;
                    }

                    if (   $plid == 542
                        && $seqtype ne 'na')
                    {
                        if ($exception == 25) {
                            $limit    = $guaranteed if ($guaranteed < $limit);
                            $check    = $limit;
                            $do_count = 0;
                        } else {
                            if ($slottotal < $guaranteed) {
                                $limit = $guaranteed;
                            } elsif ($slottotal <= ($guaranteed + $dynamic)) {
                                $limit = $dynamic;
                            }
                        }
                    }

                    if (   $plid == 643
                        && defined($page_options->{BlockNew})
                        && int($page_options->{BlockNew} || 0) == 1)
                    {
                        $limit = 0;
                    }
                    if (   $plid == 632
                        && defined($page_options->{BlockAll})
                        && int($page_options->{BlockAll} || 0) == 1)
                    {
                        $limit = 0;
                    }
                    if ($do_count
                        && !defined($seqhash->{_protect_sequencecheck}))
                    {
                        $check += $limit;
                    }
                } elsif ($placegroup eq 'media'
                    && exists($seqhash->{Size}))
                {
                    my ($seq_width, $seq_height) = split('x', $seqhash->{Size});
                    $limit = 0
                      unless (defined($media_width)
                        && defined($media_height)
                        && $seq_width <= $media_width
                        && $seq_height <= $media_height);
                    $do_count = 0 if ($slottotal > 0);
                } elsif ($placegroup eq 'stripe') {
                    if (exists($page_bk_data->{Places}->{$plid})) {
                        $limit = 1;
                        $check = 1;
                    }
                }

                $slottotal += $limit if ($do_count);

                push @{$page_slots->{$slotid}->{Sequences}},
                  {
                    SequenceID    => $seqid,
                    PrintSlotID   => $printslot,
                    PrintSeqID    => $printseq,
                    PlaceID       => $plid,
                    PlaceSelect   => $select,
                    SequenceLimit => $limit,
                    SequenceCheck => $check,
                    SequenceType  => $seqtype,
                    ExceptionID   => $exception,
                    OrderType     => $ordertype
                  };
            }
        }
    }

    return 1;
}

sub _set_page_id_if_need_and_call {
    my ($self, $method, $bk_data, @opts) = @_;

    foreach my $data (values %$bk_data) {
        $data->{PageID} //= $self->api_utils_partner2->get_next_page_id();
    }

    return $self->call($method, $bk_data, @opts);
}

sub _get_source {
    my ($self, $source) = @_;

    return get_domain($source, ascii => 1) // get_bundle_id($source, 1) // get_bundle_id($source, 2)
      // throw Exception "Invalid source: $source";
}

sub _send_to_java_protobuf_logbroker {
    my ($self, $campaign_bk_data) = @_;

    my $enriched_page = $self->api_java_bk_data->sent_protobuf_to_logbroker_by_java($campaign_bk_data);

    return 1;
}

sub _send_to_logbroker {
    my ($self, $campaign_bk_data) = @_;

    my $topic = $self->get_option('logbroker_topic');
    throw Exception::BK 'logbroker_topic should be set'
      unless $topic;

    my $json_string = to_json($campaign_bk_data);

    send_to_graphite(
        path    => "Page.bk.logbroker_data_size",
        value   => length($json_string),
        solomon => {
            metric => 'bk_data_size',
            sensor => 'Page.bk_data'
        }
    );

    return $self->api_selfservice->logbroker(
        data => [
            {
                Data     => $json_string,
                UnixTime => time,
            },
        ],
        topic       => $topic,
        skip_log_ok => !$self->need_log_all,
    );
}

sub get_transports_to_send {
    my ($self, $page_model, $page_id, $opts) = @_;

    my $curr_page_id_transports =
      ($self->app->get_option('curr_page_id_transports') // {})->{$page_model}->{$page_model};

    my $is_send_to_bssoap    = 1;
    my $is_send_to_logbroker = 1;
    my $is_send_protobuf     = 0;
    if (defined $curr_page_id_transports) {
        ($is_send_to_bssoap, $is_send_to_logbroker, $is_send_protobuf) =
          @$curr_page_id_transports{qw(bssoap logbroker protobuf)};
    } else {
        $opts = {map {%$_} grep {ref $_ eq 'HASH'} @$opts};

        if ($opts->{protobuf_only}) {
            $is_send_protobuf     = 1;
            $is_send_to_logbroker = 0;
            $is_send_to_bssoap    = 0;
        } else {
            $is_send_protobuf = $self->_get_and_update_chi_key($PROTOBUF_JAVA_TRANSPORT_TURN_ON_KEY, 0, '10 min');
            if ($opts->{logbrocker_only}) {
                $is_send_to_logbroker = 1;
                $is_send_to_bssoap    = 0;
            } else {
                $is_send_to_logbroker = $self->_is_send_page_to_transport($page_model, $page_id, 'logbroker');
                $is_send_to_bssoap    = $self->_is_send_page_to_transport($page_model, $page_id, 'bssoap');
            }
        }
    }

    $is_send_to_bssoap = 1 if !$is_send_protobuf && !$is_send_to_logbroker;

    unless (defined $curr_page_id_transports) {
        $self->app->set_option(
            curr_page_id_transports => {
                $page_model => {
                    $page_id => {
                        $is_send_to_bssoap    => $is_send_to_bssoap,
                        $is_send_to_logbroker => $is_send_to_logbroker,
                        $is_send_protobuf     => $is_send_protobuf,
                    }
                }
            }
        );
    }

    return ($is_send_to_bssoap, $is_send_to_logbroker, $is_send_protobuf);
}

sub _is_send_page_to_transport {
    my ($self, $page_model, $page_id, $transport_name) = @_;

    my $kv_store_keys = $TRANSPORTS_KVSTORE_KEYS->{$transport_name};

    my $never_min_page_id = $self->_get_and_update_chi_key($kv_store_keys->{never_min_page_id}, -1, '10 min');
    my $always_pages  = $self->_get_and_update_chi_key($kv_store_keys->{always_pages},  '', '10 min', 'split_by_comma');
    my $never_pages   = $self->_get_and_update_chi_key($kv_store_keys->{never_pages},   '', '10 min', 'split_by_comma');
    my $always_models = $self->_get_and_update_chi_key($kv_store_keys->{always_models}, '', '10 min', 'split_by_comma');
    my $never_models  = $self->_get_and_update_chi_key($kv_store_keys->{never_models},  '', '10 min', 'split_by_comma');
    my $modulo_devisor = $self->_get_and_update_chi_key($kv_store_keys->{modulo_devisor}, 0, '10 min');
    my $modulo_reminders =
      $self->_get_and_update_chi_key($kv_store_keys->{modulo_reminders}, '', '10 min', 'split_by_comma');
    my $probability = $self->_get_and_update_chi_key($kv_store_keys->{probability}, 100, '10 min');

    my $is_send = 1;
    if (%$always_pages && $always_pages->{$page_id}) {
        $is_send = 1;
    } elsif (%$never_pages && $never_pages->{$page_id}) {
        $is_send = 0;
    } elsif ($never_min_page_id > 0 && $page_id >= $never_min_page_id) {
        $is_send = 0;
    } elsif (%$always_models && $always_models->{$page_model}) {
        $is_send = 1;
    } elsif (%$never_models && $never_models->{$page_model}) {
        $is_send = 0;
    } elsif ($modulo_devisor > 0 && %$modulo_reminders) {
        my $reminder = $page_id % $modulo_devisor;
        $is_send = $modulo_reminders->{$reminder} ? 1 : 0;
    } elsif ($probability < 100) {
        my $rand = int(rand(100));
        $is_send = $rand <= $probability ? 1 : 0;
    }

    return $is_send;
}

sub _get_and_update_chi_key {
    my ($self, $key, $default, $ttl, $is_split_by_comma) = @_;

    $CHI_CACHE = CHI->new(driver => 'Memory', global => 1) unless $CHI_CACHE;

    my $val = $CHI_CACHE->get($key);

    unless (defined $val) {
        $val = $self->kv_store->get($key);
        $val = $default if !defined $val || $val eq '';
        $val = {map {$_ => 1} split(/,/, $val)} if $is_split_by_comma;
        $CHI_CACHE->set($key, $val, $ttl);
    }

    return $val;
}

sub log {
    my ($self, $data) = @_;

    rmap_all {$_ = $_->value if ref($_) eq 'SOAP::Data'} $data->{'params'};
    my $json   = Encode::encode_utf8(to_json($data->{params}));
    my $to_log = {
        dt => curdate(oformat => 'db_time'),
        page_id => $data->{params}[0]{0}{'PageID'} // $data->{response}[0]{0}{'PageID'},
        login => $ENV{LOGIN} // '',
        request  => pack('L', length($json)) . compress($json),
        response => to_json($data->{response}),
        error    => $self->canonical_error_message($data->{'error'}),
    };
    $self->partner_logs_db->bk_edit_page->add($to_log);

    $self->SUPER::log($data) unless $data->{method} eq 'EditPage';
}

TRUE;
