package Application::Model::API::Yandex::BannerStorage::HTTP;

use qbit;
use Utils::Logger qw(ERROR);

use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use Exception::BannerStorage::HTTP;
use Exception::API::HTTP;

sub accessor {'api_http_banner_storage'}

sub call {
    my ($self, $url, %opts) = @_;

    $ENV{'LAST_HTTP_URL'} = $url;

    # TODO: Rethrow?
    my $result;
    try {
        my $json_result = $self->SUPER::call("$url?token=" . $self->get_option('token', ''), %opts);

        $result = from_json($json_result);
    }
    catch Exception::API::HTTP with {
        my ($exception) = @_;

        my $response = $exception->{'response'};

        if ($response->code == 400) {
            my $json_result = $response->decoded_content();

            $result = from_json($json_result);
        } else {
            throw Exception::BannerStorage::HTTP gettext('Incorrect answer');
        }
    }
    catch {
        throw Exception::BannerStorage::HTTP gettext('Incorrect answer');
    };

    throw Exception::BannerStorage::HTTP "$result->{'message'} " . join(', ', @{$result->{'validationErrors'}})
      if defined($result->{'validationErrors'});

    return $result;
}

sub partner_customers {
    my ($self, %opts) = @_;

    $self->app->validator->check(
        data     => \%opts,
        template => {
            type   => 'hash',
            fields => {
                login    => {},
                password => {},
                name     => {},
                user_id  => {type => 'int_un'},
            },
        },
        throw_internal_error => TRUE,
    );

    my %params = hash_transform(\%opts, ['name', 'password'], {login => 'Login', user_id => 'passportId'});

    return $self->call(
        'partner/customers',
        ':post'         => TRUE,
        ':content_type' => 'application/json',
        ':content'      => to_json(\%params)
    );
}

TRUE;
