package Application::Model::API::Yandex::JavaBKData;

use qbit;
use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use Utils::DB qw(get_db_connection_header);

use Exception::API::HTTP;

sub accessor {'api_java_bk_data'}

sub sent_protobuf_to_logbroker_by_java {
    my ($self, $campaign_bk_data) = @_;

    my $base_url = $self->_get_base_url();

    my $response;
    try {
        my $r = $self->call(
            'bk_page_update',
            ':post'    => 1,
            ':url'     => $base_url,
            ':headers' => {
                'Accept'       => 'application/vnd.api+json',
                'Content-Type' => 'application/vnd.api+json'
            },
            ':content' => to_json($campaign_bk_data),
        );
        $response = from_json($r, keep_utf => TRUE);
    }
    catch {
        my ($e) = @_;
        throw Exception::API::HTTP $e, sentry => {fingerprint => ['JavaBkData', 'sent_protobuf_to_logbroker_by_java']};
    };

    return $response;
}

sub enrich_page {
    my ($self, %opts) = @_;

    return unless $opts{page_bk_data};

    my $new_bk_data = clone($opts{page_bk_data});

    # т.к. Slots зависит от TargetType, которого здесь нет, а для расчета блоков и вовсе не нужны
    $new_bk_data->{Slots} = [];

    my %normalized_bk_data = $self->app->api_bk->_get_bk_data([$new_bk_data]);

    delete $normalized_bk_data{'0'}{Slots};

    my $base_url = $self->_get_base_url();

    my $response;
    try {
        my $r = $self->call(
            'enrich_page',
            ':post'    => 1,
            ':url'     => $base_url,
            ':headers' => {'Content-Type' => 'application/json', get_db_connection_header($self->app)},
            ':content' => to_json($normalized_bk_data{"0"}),
            'read_only' => $opts{read_only} // 0,
        );
        $response = from_json($r, keep_utf => TRUE);
    }
    catch {
        my ($e) = @_;
        throw Exception::API::HTTP $e, sentry => {fingerprint => ['JavaBkData', 'enrich_page']};
    };

    return $response;
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        my $res = $self->call(
            'enrich_page',
            ':post'    => 1,
            ':headers' => {'Content-Type' => 'application/json',},
            ':content' => to_json({}),
        );
    }
    catch {
        my ($e) = @_;
        if ($e->message =~ /403 Forbidden/) {
            $result = TRUE;
        }
    };

    return $result;
}

sub _get_base_url {
    my ($self) = @_;

    my $base_url = $self->get_option('url');
    # из кронов и prod-ваншотов нужно ходить в соотв. балансер
    my $oneshot_option  = $self->app->get_option('oneshot');
    my $is_prod_oneshot = $oneshot_option && $oneshot_option eq 'production';
    my $is_deploy_cron  = $ENV{DEPLOY_BOX_ID} && $ENV{DEPLOY_BOX_ID} eq 'CronApp';
    if ($is_prod_oneshot or $is_deploy_cron) {
        $base_url = $self->get_option('balancer_url') || $base_url;
    }

    return $base_url;
}

TRUE;
