package Application::Model::API::Yandex::JavaJsonApi;

use qbit;

use base qw(QBit::Application::Model::API::HTTP Application::Model::API::HTTPLogger);

use Utils::DB qw(get_db_connection_header);

use PiConstants qw($CONTENT_TYPE);

sub accessor {'api_java_jsonapi'}

sub call {
    my ($self, $method, %params) = @_;

    my $user_id = delete($params{'user_id'}) // throw Exception::Validation::BadArguments gettext('Expected "user_id"');

    $params{':url'} = $self->get_option('balancer_url')
      if $ENV{DEPLOY_BOX_ID} && $ENV{DEPLOY_BOX_ID} eq 'CronApp';

    $params{':headers'} = {
        'PI-User-Id'   => $user_id,
        'Content-Type' => $CONTENT_TYPE,
        'Accept'       => $CONTENT_TYPE,
        get_db_connection_header($self->app),
    };

    my $response = $self->SUPER::call($method, %params);

    my $result = from_json($response, keep_utf => TRUE);

    return $result;
}

sub get_all {
    my ($self, $opts) = @_;

    my $method = $opts->{'resource'} // throw Exception::Validation::BadArguments gettext('Expected "resource"');

    my %params = (
        user_id => $opts->{'user_id'},
        (
            defined($opts->{'fields'})
              && @{$opts->{'fields'}} ? ("fields[$method]" => join(',', sort @{$opts->{'fields'}})) : ()
        ),
        (defined($opts->{'filter'}) ? (filter => to_json($opts->{'filter'})) : ()),
        (
            defined($opts->{'order_by'})
              && @{$opts->{'order_by'}}
            ? (sort => join(',', map {$_->[1] ? "-$_->[0]" : $_->[0]} @{$opts->{'order_by'}}))
            : ()
        ),
        (defined($opts->{'page_size'})   ? ('page[size]'   => $opts->{'page_size'})   : ()),
        (defined($opts->{'page_number'}) ? ('page[number]' => $opts->{'page_number'}) : ()),
        (defined($opts->{'meta'})        ? (meta           => $opts->{'meta'})        : ()),
    );

    return $self->call($method, %params);
}

sub check_tvm_service {
    my ($self) = @_;

    my $result;
    try {
        $self->get_all(
            {
                resource => 'users',
                user_id  => 0,
                fields   => [qw(id)],
                filter   => {id => 0},
            }
        );
    }
    catch {
        my ($e) = @_;

        my $msg = $e->message();

        if ($msg =~ /400 Bad Request/ || $msg =~ /401 Unauthorized/) {
            $result = TRUE;
        }
    };

    return $result;
}

TRUE;
